/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.connection.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.MissingBlockException;
import team.creative.littletiles.common.structure.exception.MissingStructureException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class StructureBlockConnector {
    public final BlockPos pos;
    public final LittleStructure structure;
    private BETiles cachedBE;

    public StructureBlockConnector(LittleStructure structure, BlockPos pos) {
        this.structure = structure;
        this.pos = pos;
    }

    public boolean is(BlockPos pos) {
        BlockPos structurePos = this.structure.getStructurePos();
        return structurePos.getX() + this.pos.getX() == pos.getX() && structurePos.getY() + this.pos.getY() == pos.getY() && structurePos.getZ() + this.pos.getZ() == pos.getZ();
    }

    public BlockPos getAbsolutePos() {
        return this.structure.getStructurePos().offset((Vec3i)this.pos);
    }

    public BETiles getBlockEntity() throws CorruptedConnectionException, NotYetConnectedException {
        BlockPos absoluteCoord;
        Level level;
        if (this.cachedBE != null) {
            if (this.cachedBE.isRemoved()) {
                this.cachedBE = null;
            } else {
                return this.cachedBE;
            }
        }
        if ((level = this.structure.getStructureLevel()).hasChunkAt(absoluteCoord = this.getAbsolutePos())) {
            BlockEntity be = level.getBlockEntity(absoluteCoord);
            if (be instanceof BETiles) {
                this.cachedBE = (BETiles)be;
                return this.cachedBE;
            }
            throw new MissingBlockException(absoluteCoord);
        }
        throw new NotYetConnectedException();
    }

    public void connect() throws CorruptedConnectionException, NotYetConnectedException {
        BETiles be = this.getBlockEntity();
        if (!be.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureParentCollection structure = be.getStructure(this.structure.getIndex());
        if (structure == null) {
            throw new MissingStructureException(be.getBlockPos());
        }
    }

    public IStructureParentCollection getList() throws CorruptedConnectionException, NotYetConnectedException {
        BETiles be = this.getBlockEntity();
        if (!be.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureParentCollection structure = be.getStructure(this.structure.getIndex());
        if (structure != null) {
            return structure;
        }
        throw new MissingStructureException(be.getBlockPos());
    }

    public int count() throws CorruptedConnectionException, NotYetConnectedException {
        return this.getList().size();
    }

    public void remove() throws CorruptedConnectionException, NotYetConnectedException {
        this.getBlockEntity().updateTiles(x -> x.removeStructure(this.structure.getIndex()));
    }
}

