/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.connection.children;

import java.util.ArrayList;
import java.util.Map;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import team.creative.creativecore.common.level.ISubLevel;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.ILevelPositionProvider;
import team.creative.littletiles.common.structure.connection.children.ChildrenList;
import team.creative.littletiles.common.structure.connection.children.StructureChildConnection;
import team.creative.littletiles.common.structure.connection.children.StructureChildFromSubLevelConnection;
import team.creative.littletiles.common.structure.connection.children.StructureChildToSubLevelConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class LevelChildrenList
extends ChildrenList<StructureChildConnection> {
    public final LittleStructure owner;

    public LevelChildrenList(LittleStructure owner) {
        super(null);
        this.owner = owner;
    }

    public void initAfterPlacing(int children) {
        ArrayList<Object> list = new ArrayList<Object>(children);
        for (int i = 0; i < children; ++i) {
            list.add(null);
        }
        this.set(list);
    }

    public StructureChildConnection removeExtension(String key) throws CorruptedConnectionException, NotYetConnectedException {
        StructureChildConnection ex = (StructureChildConnection)super.removeExt(key);
        if (ex != null) {
            LittleStructure parentStructure = ex.getStructure();
            if (!ex.extension) {
                throw new RuntimeException("Cannot remove non dynamic child");
            }
            parentStructure.children.parent = null;
        }
        return ex;
    }

    @Override
    protected void added(StructureChildConnection child) {
    }

    public void load(CompoundTag nbt) {
        int i;
        this.parent = nbt.contains("k") ? StructureChildConnection.load(this.owner, nbt.getCompound("k"), true) : null;
        ListTag list = nbt.getList("c", 10);
        ArrayList<StructureChildConnection> children = new ArrayList<StructureChildConnection>(list.size());
        for (i = 0; i < list.size(); ++i) {
            children.add(StructureChildConnection.load(this.owner, list.getCompound(i), false));
        }
        this.set(children);
        this.extensions.clear();
        list = nbt.getList("e", 10);
        for (i = 0; i < list.size(); ++i) {
            CompoundTag extension = list.getCompound(i);
            this.extensions.put(extension.getString("eid"), StructureChildConnection.load(this.owner, extension, false));
        }
    }

    public void save(CompoundTag nbt) {
        ListTag list;
        if (this.hasParent()) {
            nbt.put("k", (Tag)((StructureChildConnection)this.parent).save(new CompoundTag()));
        }
        if (this.hasChildren()) {
            list = new ListTag();
            for (StructureChildConnection structureChildConnection : this.children()) {
                list.add((Object)structureChildConnection.save(new CompoundTag()));
            }
            nbt.put("c", (Tag)list);
        }
        if (this.hasExtensions()) {
            list = new ListTag();
            for (Map.Entry entry : this.extensionEntries()) {
                CompoundTag extensionNBT = ((StructureChildConnection)entry.getValue()).save(new CompoundTag());
                extensionNBT.putString("eid", (String)entry.getKey());
                list.add((Object)extensionNBT);
            }
            nbt.put("e", (Tag)list);
        }
    }

    public void connectToChild(int i, LittleStructure child) {
        StructureChildConnection connector;
        Level level = this.owner.getStructureLevel();
        Level childLevel = child.getStructureLevel();
        if (childLevel == level) {
            connector = new StructureChildConnection(this.owner, false, false, i, child.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), child.getIndex(), child.getAttribute());
        } else if (childLevel instanceof ISubLevel) {
            connector = new StructureChildToSubLevelConnection((ILevelPositionProvider)this.owner, false, i, child.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), child.getIndex(), child.getAttribute(), ((ISubLevel)childLevel).getHolder().getUUID());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        this.set(i, connector);
    }

    public void connectToExtension(String extension, LittleStructure child) {
        StructureChildConnection connector;
        Level level = this.owner.getStructureLevel();
        Level childLevel = child.getStructureLevel();
        if (childLevel == level) {
            connector = new StructureChildConnection(this.owner, false, false, -1, child.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), child.getIndex(), child.getAttribute());
        } else if (childLevel instanceof ISubLevel) {
            connector = new StructureChildToSubLevelConnection((ILevelPositionProvider)this.owner, false, -1, child.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), child.getIndex(), child.getAttribute(), ((ISubLevel)childLevel).getHolder().getUUID());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        this.extensions.put(extension, connector);
    }

    public void connectToParentAsChild(int i, LittleStructure parent) {
        StructureChildConnection connector;
        Level level = this.owner.getStructureLevel();
        Level parentLevel = parent.getStructureLevel();
        if (parentLevel == level) {
            connector = new StructureChildConnection(this.owner, true, false, i, parent.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), parent.getIndex(), parent.getAttribute());
        } else if (level instanceof ISubLevel) {
            connector = new StructureChildFromSubLevelConnection(this.owner, false, i, parent.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), parent.getIndex(), parent.getAttribute());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        this.parent = connector;
    }

    public void connectToParentAsExtension(LittleStructure parent) {
        StructureChildConnection connector;
        Level level = this.owner.getStructureLevel();
        Level parentLevel = parent.getStructureLevel();
        if (parentLevel == level) {
            connector = new StructureChildConnection(this.owner, true, true, -1, parent.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), parent.getIndex(), parent.getAttribute());
        } else if (level instanceof ISubLevel) {
            connector = new StructureChildFromSubLevelConnection(this.owner, true, -1, parent.getStructurePos().subtract((Vec3i)this.owner.getStructurePos()), parent.getIndex(), parent.getAttribute());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        this.parent = connector;
    }

    public StructureChildConnection generateConnection(ILevelPositionProvider parent) {
        StructureChildConnection connector;
        Level level = this.owner.getStructureLevel();
        Level parentLevel = parent.getStructureLevel();
        if (parentLevel == level) {
            connector = new StructureChildConnection(parent, true, false, 0, this.owner.getStructurePos().subtract((Vec3i)parent.getStructurePos()), this.owner.getIndex(), this.owner.getAttribute());
        } else if (level instanceof ISubLevel) {
            connector = new StructureChildToSubLevelConnection(parent, false, 0, this.owner.getStructurePos().subtract((Vec3i)parent.getStructurePos()), this.owner.getIndex(), this.owner.getAttribute(), ((ISubLevel)level).getHolder().getUUID());
        } else {
            throw new RuntimeException("Invalid connection between to structures!");
        }
        return connector;
    }

    public boolean hasChild(int child) {
        return child >= 0 && child < this.sizeChildren();
    }

    public StructureChildConnection getChild(int child) throws CorruptedConnectionException, NotYetConnectedException {
        if (child >= 0 && child < this.sizeChildren()) {
            return (StructureChildConnection)this.getChildDirectly(child);
        }
        throw new CorruptedConnectionException("child with id " + child + " does not exist");
    }
}

