/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.connection.children;

import java.security.InvalidParameterException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import team.creative.littletiles.common.block.entity.BETiles;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.entity.LittleEntity;
import team.creative.littletiles.common.level.LittleUpdateCollector;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.connection.ILevelPositionProvider;
import team.creative.littletiles.common.structure.connection.IStructureConnection;
import team.creative.littletiles.common.structure.connection.children.StructureChildFromSubLevelConnection;
import team.creative.littletiles.common.structure.connection.children.StructureChildToSubLevelConnection;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.CorruptedLinkException;
import team.creative.littletiles.common.structure.exception.MissingBlockException;
import team.creative.littletiles.common.structure.exception.MissingStructureException;
import team.creative.littletiles.common.structure.exception.MissingWorldException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public class StructureChildConnection
implements IStructureConnection {
    public final ILevelPositionProvider parent;
    public final boolean isChild;
    public final int childId;
    public final boolean extension;
    private final int structureIndex;
    private final int attribute;
    private final BlockPos relativePos;
    private BETiles cachedBE;

    public StructureChildConnection(ILevelPositionProvider parent, boolean isChild, boolean extension, int childId, BlockPos relative, int index, int attribute) {
        this.parent = parent;
        this.isChild = isChild;
        this.childId = childId;
        this.structureIndex = index;
        this.attribute = attribute;
        this.relativePos = relative;
        this.extension = extension;
    }

    public StructureChildConnection(ILevelPositionProvider parent, boolean isChild, CompoundTag nbt) {
        this.parent = parent;
        this.isChild = isChild;
        this.childId = nbt.getInt("child");
        this.attribute = nbt.getInt("type");
        this.structureIndex = nbt.getInt("index");
        this.extension = nbt.getBoolean("extension");
        int[] array = nbt.getIntArray("coord");
        if (array.length != 3) {
            throw new InvalidParameterException("No valid coord given " + String.valueOf(nbt));
        }
        this.relativePos = new BlockPos(array[0], array[1], array[2]);
    }

    public boolean isChild() {
        return this.isChild;
    }

    public int getChildId() {
        return this.childId;
    }

    public CompoundTag save(CompoundTag nbt) {
        nbt.putInt("child", this.childId);
        nbt.putIntArray("coord", new int[]{this.relativePos.getX(), this.relativePos.getY(), this.relativePos.getZ()});
        nbt.putInt("type", this.attribute);
        nbt.putInt("index", this.structureIndex);
        if (this.extension) {
            nbt.putBoolean("extension", this.extension);
        }
        return nbt;
    }

    public void destroyStructure(LittleUpdateCollector neighbor) throws CorruptedConnectionException, NotYetConnectedException {
        if (!this.isChild()) {
            this.getStructure().removeStructure(neighbor);
        }
    }

    public void destroyStructureSameLevel(LittleUpdateCollector neighbor) throws CorruptedConnectionException, NotYetConnectedException {
        if (!this.isChild()) {
            this.getStructure().removeStructureSameLevel(neighbor);
        }
    }

    public LittleEntity getAnimation() {
        return null;
    }

    @Override
    public BlockPos getStructurePosition() {
        return this.relativePos.offset((Vec3i)this.parent.getStructurePos());
    }

    @Override
    public LittleStructure getStructure() throws CorruptedConnectionException, NotYetConnectedException {
        BETiles be = this.getBlockEntity();
        if (!be.hasLoaded()) {
            throw new NotYetConnectedException();
        }
        IStructureParentCollection structure = be.getStructure(this.structureIndex);
        if (structure != null) {
            return structure.getStructure();
        }
        throw new MissingStructureException(be.getBlockPos());
    }

    protected Level getLevel() throws CorruptedConnectionException, NotYetConnectedException {
        return this.parent.getStructureLevel();
    }

    protected BETiles getBlockEntity() throws CorruptedConnectionException, NotYetConnectedException {
        if (this.cachedBE != null && !this.cachedBE.isRemoved() && !this.cachedBE.unloaded()) {
            return this.cachedBE;
        }
        if (this.relativePos == null) {
            throw new CorruptedLinkException();
        }
        Level level = this.getLevel();
        if (level == null) {
            throw new MissingWorldException();
        }
        BlockPos absoluteCoord = this.getStructurePosition();
        if (level.hasChunkAt(absoluteCoord)) {
            BlockEntity be = level.getBlockEntity(absoluteCoord);
            if (be instanceof BETiles) {
                this.cachedBE = (BETiles)be;
                return this.cachedBE;
            }
            throw new MissingBlockException(absoluteCoord);
        }
        throw new NotYetConnectedException();
    }

    public void clearCache() {
        this.cachedBE = null;
    }

    @Override
    public int getIndex() {
        return this.structureIndex;
    }

    @Override
    public int getAttribute() {
        return this.attribute;
    }

    public static StructureChildConnection load(ILevelPositionProvider structure, CompoundTag nbt, boolean isChild) {
        if (nbt.contains("entity")) {
            return new StructureChildToSubLevelConnection(structure, nbt);
        }
        if (nbt.getBoolean("subWorld")) {
            return new StructureChildFromSubLevelConnection(structure, nbt);
        }
        return new StructureChildConnection(structure, isChild, nbt);
    }
}

