/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.component;

import net.minecraft.world.level.Level;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.SignalComponentType;

public interface ISignalComponent {
    public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException;

    default public void updateState(SignalState state) {
        try {
            if (!state.equals(this.getBandwidth(), this.getState())) {
                this.overwriteState(state);
                this.changed();
            }
        }
        catch (CorruptedConnectionException | NotYetConnectedException structureException) {
            // empty catch block
        }
    }

    public void changed() throws CorruptedConnectionException, NotYetConnectedException;

    public SignalState getState() throws CorruptedConnectionException, NotYetConnectedException;

    @Deprecated
    public void overwriteState(SignalState var1) throws CorruptedConnectionException, NotYetConnectedException;

    public SignalComponentType getComponentType();

    public LittleStructure getStructure();

    public Level getStructureLevel();
}

