/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.logic;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.common.gui.GuiControl;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.gui.control.simple.GuiLabel;
import team.creative.creativecore.common.gui.control.simple.GuiTextfield;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.LittleStructure;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.component.ISignalComponent;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;
import team.creative.littletiles.common.structure.signal.schedule.SignalScheduleTicket;

public enum SignalMode {
    EQUAL("signal.mode.equal"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalOutputHandler handler = new SignalOutputHandler(this, component, delay, nbt){

                @Override
                public SignalMode getMode() {
                    return EQUAL;
                }

                @Override
                public void queue(SignalState state) {
                    LittleTiles.TICKERS.schedule(this, state, this.delay);
                }

                @Override
                public void write(boolean preview, CompoundTag nbt) {
                    if (preview) {
                        return;
                    }
                    List<SignalScheduleTicket> tickets = LittleTiles.TICKERS.findTickets(this.component, this);
                    ListTag list = new ListTag();
                    for (int i = 0; i < tickets.size(); ++i) {
                        SignalScheduleTicket ticket = tickets.get(i);
                        list.add((Object)new IntArrayTag(new int[]{ticket.getDelay(), ticket.getState().number()}));
                    }
                    if (!list.isEmpty()) {
                        nbt.put("tickets", (Tag)list);
                    }
                }
            };
            if (hasWorld) {
                ListTag list = nbt.getList("tickets", 11);
                for (int i = 0; i < list.size(); ++i) {
                    int[] array = list.getIntArray(i);
                    if (array.length != 2) continue;
                    try {
                        SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                        LittleTiles.TICKERS.schedule(handler, state, array[0]);
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
            return handler;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationEqual(handler);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationEqual(delay);
        }
    }
    ,
    TOGGLE("signal.mode.toggle"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalState result;
            SignalState before;
            int bandwidth = nbt.getInt("bandwidth");
            if (bandwidth > 0) {
                before = SignalState.create(bandwidth);
                result = SignalState.create(bandwidth);
                before = before.load(nbt.get("before"));
                result = result.load(nbt.get("result"));
            } else {
                before = null;
                result = null;
            }
            SignalOutputHandlerToggle handler = new SignalOutputHandlerToggle(component, delay, nbt, before, result);
            if (hasWorld) {
                ListTag list = nbt.getList("tickets", 11);
                for (int i = 0; i < list.size(); ++i) {
                    int[] array = list.getIntArray(i);
                    if (array.length != 2) continue;
                    try {
                        SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                        LittleTiles.TICKERS.schedule(handler, state, array[0]);
                        continue;
                    }
                    catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                        // empty catch block
                    }
                }
            }
            return handler;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationToggle(handler);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationToggle(delay);
        }
    }
    ,
    PULSE("signal.mode.pulse"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalOutputHandlerPulse condition = new SignalOutputHandlerPulse(component, delay, nbt);
            if (hasWorld) {
                if (nbt.contains("start")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.TRUE, nbt.getInt("start"));
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                } else if (nbt.contains("end")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                }
            }
            return condition;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationPulse(handler);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
            parent.add((GuiControl)new GuiLabel("length:").setTitle((Component)Component.translatable((String)"gui.signal.length").append(":")));
            parent.add((GuiControl)new GuiTextfield("length", "" + (configuration instanceof GuiSignalModeConfigurationPulse ? ((GuiSignalModeConfigurationPulse)configuration).length : 10)).setNumbersOnly());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            GuiTextfield length = (GuiTextfield)parent.get("length");
            return new GuiSignalModeConfigurationPulse(delay, Math.max(1, length.parseInteger()));
        }
    }
    ,
    THRESHOLD("signal.mode.threshold"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            int[] array;
            SignalOutputHandlerStoreOne handler = new SignalOutputHandlerStoreOne(this, component, delay, nbt){

                @Override
                public void queue(SignalState state) {
                    if (this.ticket != null) {
                        this.ticket.overwriteState(state);
                    } else {
                        this.ticket = LittleTiles.TICKERS.schedule(this, state, this.delay);
                    }
                }

                @Override
                public void performStateChange(SignalState state) {
                    this.ticket = null;
                    super.performStateChange(state);
                }

                @Override
                public SignalMode getMode() {
                    return THRESHOLD;
                }

                @Override
                public void write(boolean preview, CompoundTag nbt) {
                    if (!preview && this.ticket != null) {
                        nbt.putIntArray("ticket", new int[]{this.ticket.getDelay(), this.ticket.getState().number()});
                    }
                }
            };
            if (hasWorld && nbt.contains("ticket") && (array = nbt.getIntArray("ticket")).length == 2) {
                try {
                    SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                    handler.ticket = LittleTiles.TICKERS.schedule(handler, state, array[0]);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return handler;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationThreshold(handler);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationThreshold(delay);
        }
    }
    ,
    STABILIZER("signal.mode.stabilizer"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            int[] array;
            SignalOutputHandlerStoreOne handler = new SignalOutputHandlerStoreOne(this, component, delay, nbt){

                @Override
                public void queue(SignalState state) {
                    if (this.ticket != null) {
                        this.ticket.markObsolete();
                    }
                    this.ticket = LittleTiles.TICKERS.schedule(this, state, this.delay);
                }

                @Override
                public void performStateChange(SignalState state) {
                    this.ticket = null;
                    super.performStateChange(state);
                }

                @Override
                public SignalMode getMode() {
                    return STABILIZER;
                }

                @Override
                public void write(boolean preview, CompoundTag nbt) {
                    if (preview) {
                        return;
                    }
                    if (this.ticket != null) {
                        nbt.putIntArray("ticket", new int[]{this.ticket.getDelay(), this.ticket.getState().number()});
                    }
                }
            };
            if (hasWorld && nbt.contains("ticket") && (array = nbt.getIntArray("ticket")).length == 2) {
                try {
                    SignalState state = SignalState.create(component.getBandwidth()).load(array[1]);
                    handler.ticket = LittleTiles.TICKERS.schedule(handler, state, array[0]);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            return handler;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationStabilizer(handler);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            return new GuiSignalModeConfigurationStabilizer(delay);
        }
    }
    ,
    EXTENDER("signal.mode.extender"){

        @Override
        public SignalOutputHandler create(ISignalComponent component, int delay, CompoundTag nbt, boolean hasWorld) {
            SignalOutputHandlerExtender condition = new SignalOutputHandlerExtender(component, delay, nbt);
            if (hasWorld) {
                if (nbt.contains("start")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.TRUE, nbt.getInt("start"));
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                } else if (nbt.contains("end")) {
                    LittleTiles.TICKERS.schedule(condition, SignalState.FALSE, nbt.getInt("end"));
                }
            }
            return condition;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration createConfiguration(SignalOutputHandler handler) {
            return new GuiSignalModeConfigurationExtender(handler);
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void createControls(GuiParent parent, GuiSignalModeConfiguration configuration) {
            parent.add((GuiControl)new GuiLabel("length:").setTitle((Component)Component.translatable((String)"gui.signal.length").append(":")));
            parent.add((GuiControl)new GuiTextfield("length", "" + (configuration instanceof GuiSignalModeConfigurationExtender ? ((GuiSignalModeConfigurationExtender)configuration).length : 10)).setNumbersOnly());
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GuiSignalModeConfiguration parseControls(GuiParent parent, int delay) {
            GuiTextfield length = (GuiTextfield)parent.get("length");
            return new GuiSignalModeConfigurationExtender(delay, Math.max(1, length.parseInteger()));
        }
    };

    public final String translateKey;

    private SignalMode(String translateKey) {
        this.translateKey = translateKey;
    }

    public abstract SignalOutputHandler create(ISignalComponent var1, int var2, CompoundTag var3, boolean var4);

    @OnlyIn(value=Dist.CLIENT)
    public abstract GuiSignalModeConfiguration createConfiguration(SignalOutputHandler var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void createControls(GuiParent var1, GuiSignalModeConfiguration var2);

    @OnlyIn(value=Dist.CLIENT)
    public abstract GuiSignalModeConfiguration parseControls(GuiParent var1, int var2);

    @OnlyIn(value=Dist.CLIENT)
    public static GuiSignalModeConfiguration getConfigDefault() {
        return EQUAL.createConfiguration(null);
    }

    public static SignalMode get(String test) {
        try {
            return SignalMode.valueOf(test);
        }
        catch (IllegalArgumentException e) {
            return EQUAL;
        }
    }

    public static SignalMode get(String test, SignalMode defaultMode) {
        try {
            return SignalMode.valueOf(test);
        }
        catch (IllegalArgumentException e) {
            return defaultMode;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class GuiSignalModeConfiguration {
        public int delay;

        public GuiSignalModeConfiguration(SignalOutputHandler handler) {
            this(handler != null ? handler.delay : 1);
        }

        public GuiSignalModeConfiguration(int delay) {
            this.delay = delay;
        }

        public abstract SignalMode getMode();

        public abstract GuiSignalModeConfiguration copy();

        public abstract SignalOutputHandler getHandler(ISignalComponent var1, LittleStructure var2);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GuiSignalModeConfigurationStabilizer
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationStabilizer(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationStabilizer(SignalOutputHandler handler) {
            super(handler);
        }

        @Override
        public SignalMode getMode() {
            return STABILIZER;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationStabilizer(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GuiSignalModeConfigurationThreshold
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationThreshold(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationThreshold(SignalOutputHandler handler) {
            super(handler);
        }

        @Override
        public SignalMode getMode() {
            return THRESHOLD;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationThreshold(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GuiSignalModeConfigurationExtender
    extends GuiSignalModeConfiguration {
        public int length;

        public GuiSignalModeConfigurationExtender(int delay, int length) {
            super(delay);
            this.length = length;
        }

        public GuiSignalModeConfigurationExtender(SignalOutputHandler handler) {
            super(handler);
            int n;
            if (handler instanceof SignalOutputHandlerExtender) {
                SignalOutputHandlerExtender extender = (SignalOutputHandlerExtender)handler;
                n = extender.pulseLength;
            } else {
                n = 10;
            }
            this.length = n;
        }

        @Override
        public SignalMode getMode() {
            return EXTENDER;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationExtender(this.delay, this.length);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("delay", this.delay);
            nbt.putInt("length", this.length);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GuiSignalModeConfigurationPulse
    extends GuiSignalModeConfiguration {
        public int length;

        public GuiSignalModeConfigurationPulse(int delay, int length) {
            super(delay);
            this.length = length;
        }

        public GuiSignalModeConfigurationPulse(SignalOutputHandler handler) {
            super(handler);
            int n;
            if (handler instanceof SignalOutputHandlerPulse) {
                SignalOutputHandlerPulse pulse = (SignalOutputHandlerPulse)handler;
                n = pulse.pulseLength;
            } else {
                n = 10;
            }
            this.length = n;
        }

        @Override
        public SignalMode getMode() {
            return PULSE;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationPulse(this.delay, this.length);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("delay", this.delay);
            nbt.putInt("length", this.length);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GuiSignalModeConfigurationToggle
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationToggle(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationToggle(SignalOutputHandler handler) {
            super(handler);
        }

        @Override
        public SignalMode getMode() {
            return TOGGLE;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationToggle(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GuiSignalModeConfigurationEqual
    extends GuiSignalModeConfiguration {
        public GuiSignalModeConfigurationEqual(int delay) {
            super(delay);
        }

        public GuiSignalModeConfigurationEqual(SignalOutputHandler handler) {
            this(handler != null ? handler.delay : 1);
        }

        @Override
        public SignalMode getMode() {
            return EQUAL;
        }

        @Override
        public GuiSignalModeConfiguration copy() {
            return new GuiSignalModeConfigurationEqual(this.delay);
        }

        @Override
        public SignalOutputHandler getHandler(ISignalComponent component, LittleStructure structure) {
            CompoundTag nbt = new CompoundTag();
            nbt.putInt("delay", this.delay);
            return this.getMode().create(component, this.delay, nbt, false);
        }
    }

    public static class SignalOutputHandlerExtender
    extends SignalOutputHandler {
        public final int pulseLength;
        public boolean stateBefore;
        public SignalScheduleTicket pulseStart;
        public SignalScheduleTicket pulseEnd;

        public SignalOutputHandlerExtender(ISignalComponent component, int delay, CompoundTag nbt) {
            super(component, delay, nbt);
            this.pulseLength = nbt.contains("length") ? nbt.getInt("length") : 10;
            this.stateBefore = nbt.getBoolean("before");
        }

        @Override
        public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
            return super.getBandwidth();
        }

        @Override
        public SignalMode getMode() {
            return EXTENDER;
        }

        @Override
        public void performStateChange(SignalState state) {
            super.performStateChange(state);
            if (state.any()) {
                this.pulseStart = null;
            } else {
                this.pulseStart = null;
                this.pulseEnd = null;
            }
        }

        @Override
        public void queue(SignalState state) {
            try {
                int bandwidth = this.getBandwidth();
                boolean current = state.any();
                if (!this.stateBefore && current) {
                    if (this.pulseEnd != null) {
                        this.pulseEnd.markObsolete();
                        this.pulseEnd = null;
                    } else if (this.pulseStart == null) {
                        SignalState startState = SignalState.create(bandwidth).fill(true);
                        this.pulseStart = LittleTiles.TICKERS.schedule(this, startState, this.delay);
                    }
                } else if (this.stateBefore && !current) {
                    if (this.pulseEnd != null) {
                        this.pulseEnd.markObsolete();
                        this.pulseEnd = null;
                    }
                    this.pulseEnd = LittleTiles.TICKERS.schedule(this, SignalState.create(bandwidth), this.delay + this.pulseLength);
                }
                this.stateBefore = current;
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }

        @Override
        public void write(boolean preview, CompoundTag nbt) {
            nbt.putInt("length", this.pulseLength);
            nbt.putBoolean("before", this.stateBefore);
            if (preview) {
                return;
            }
            if (this.pulseStart != null) {
                nbt.putInt("start", this.pulseStart.getDelay());
            }
            if (this.pulseEnd != null) {
                nbt.putInt("end", this.pulseEnd.getDelay());
            }
        }
    }

    public static class SignalOutputHandlerPulse
    extends SignalOutputHandler {
        public final int pulseLength;
        public boolean stateBefore;
        public SignalScheduleTicket pulseStart;
        public SignalScheduleTicket pulseEnd;

        public SignalOutputHandlerPulse(ISignalComponent component, int delay, CompoundTag nbt) {
            super(component, delay, nbt);
            this.pulseLength = nbt.contains("length") ? nbt.getInt("length") : 10;
            this.stateBefore = nbt.getBoolean("before");
        }

        @Override
        public int getBandwidth() throws CorruptedConnectionException, NotYetConnectedException {
            return super.getBandwidth();
        }

        @Override
        public SignalMode getMode() {
            return PULSE;
        }

        @Override
        public void performStateChange(SignalState state) {
            super.performStateChange(state);
            if (state.any()) {
                this.pulseStart = null;
            } else {
                this.pulseStart = null;
                this.pulseEnd = null;
            }
        }

        @Override
        public void queue(SignalState state) {
            boolean current = state.any();
            if (this.pulseEnd == null && !this.stateBefore && current) {
                try {
                    int bandwidth = this.getBandwidth();
                    SignalState startState = SignalState.create(bandwidth).fill(true);
                    SignalState endState = SignalState.create(bandwidth);
                    this.pulseStart = LittleTiles.TICKERS.schedule(this, startState, this.delay);
                    this.pulseEnd = LittleTiles.TICKERS.schedule(this, endState, this.delay + this.pulseLength);
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            this.stateBefore = current;
        }

        @Override
        public void write(boolean preview, CompoundTag nbt) {
            nbt.putInt("length", this.pulseLength);
            nbt.putBoolean("before", this.stateBefore);
            if (preview) {
                return;
            }
            if (this.pulseStart != null) {
                nbt.putInt("start", this.pulseStart.getDelay());
            }
            if (this.pulseEnd != null) {
                nbt.putInt("end", this.pulseEnd.getDelay());
            }
        }
    }

    public static class SignalOutputHandlerToggle
    extends SignalOutputHandler {
        public SignalState stateBefore;
        public SignalState result;

        public SignalOutputHandlerToggle(ISignalComponent component, int delay, CompoundTag nbt, SignalState stateBefore, SignalState result) {
            super(component, delay, nbt);
            this.stateBefore = stateBefore;
            this.result = result;
        }

        @Override
        public SignalMode getMode() {
            return TOGGLE;
        }

        public void triggerToggle() {
            if (this.result == null) {
                try {
                    int bandwidth = this.component.getBandwidth();
                    this.result = SignalState.create(bandwidth);
                    this.result = this.result.fill(this.component.getState());
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            this.result = this.result.invert();
            this.performStateChange(this.result);
        }

        @Override
        public void queue(SignalState state) {
            try {
                int bandwidth = this.component.getBandwidth();
                if (this.stateBefore == null) {
                    this.stateBefore = SignalState.create(bandwidth);
                    this.result = SignalState.create(bandwidth);
                }
                for (int i = 0; i < bandwidth; ++i) {
                    if (!this.stateBefore.is(i) && state.is(i)) {
                        this.result = this.result.set(i, !this.result.is(i));
                    }
                    this.stateBefore = this.stateBefore.set(i, state.is(i));
                }
                LittleTiles.TICKERS.schedule(this, this.result, this.delay);
            }
            catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                // empty catch block
            }
        }

        @Override
        public void write(boolean preview, CompoundTag nbt) {
            if (this.stateBefore != null) {
                try {
                    nbt.putInt("bandwidth", this.component.getBandwidth());
                    nbt.put("before", this.stateBefore.save());
                    nbt.put("result", this.result.save());
                }
                catch (CorruptedConnectionException | NotYetConnectedException structureException) {
                    // empty catch block
                }
            }
            if (preview) {
                return;
            }
            List<SignalScheduleTicket> tickets = LittleTiles.TICKERS.findTickets(this.component, this);
            ListTag list = new ListTag();
            for (int i = 0; i < tickets.size(); ++i) {
                SignalScheduleTicket ticket = tickets.get(i);
                list.add((Object)new IntArrayTag(new int[]{ticket.getDelay(), ticket.getState().number()}));
            }
            if (!list.isEmpty()) {
                nbt.put("tickets", (Tag)list);
            }
        }
    }

    public static abstract class SignalOutputHandlerStoreOne
    extends SignalOutputHandler {
        SignalScheduleTicket ticket;

        public SignalOutputHandlerStoreOne(ISignalComponent component, int delay, CompoundTag nbt) {
            super(component, delay, nbt);
        }
    }
}

