/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.schedule;

import net.minecraft.world.level.Level;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.common.structure.exception.CorruptedConnectionException;
import team.creative.littletiles.common.structure.exception.NotYetConnectedException;

public interface ISignalSchedulable {
    public void notifyChange();

    public boolean hasChanged();

    public void markChanged();

    public void markUnchanged();

    public Level getComponentLevel();

    public boolean isStillAvailable();

    default public void updateSignaling() throws CorruptedConnectionException, NotYetConnectedException {
        this.markUnchanged();
        this.notifyChange();
    }

    default public void schedule() {
        if (!this.hasChanged() && this.isStillAvailable()) {
            LittleTiles.TICKERS.markSignalChanged(this.getComponentLevel(), this);
            this.markChanged();
        }
    }
}

