/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.signal.schedule;

import java.lang.ref.WeakReference;
import net.minecraft.world.level.Level;
import team.creative.littletiles.common.structure.signal.SignalState;
import team.creative.littletiles.common.structure.signal.output.SignalOutputHandler;

public class SignalScheduleTicket
implements Runnable {
    private final WeakReference<SignalOutputHandler> outputCondition;
    private SignalState result;
    private int delay;

    public SignalScheduleTicket(SignalOutputHandler outputCondition, SignalState result, int delay) {
        this.outputCondition = new WeakReference<SignalOutputHandler>(outputCondition);
        this.result = result;
        this.delay = delay;
    }

    @Override
    public void run() {
        SignalOutputHandler handler = (SignalOutputHandler)this.outputCondition.get();
        if (handler != null && handler.isStillAvailable()) {
            try {
                handler.performStateChange(this.result);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.markObsolete();
    }

    public int getDelay() {
        return this.delay;
    }

    public boolean is(SignalOutputHandler output) {
        return this.outputCondition.get() == output;
    }

    public SignalState getState() {
        return this.result;
    }

    public void overwriteState(SignalState newState) {
        this.result = this.result.overwrite(newState);
    }

    public void markObsolete() {
        this.outputCondition.clear();
    }

    public Level getLevel() {
        SignalOutputHandler handler = (SignalOutputHandler)this.outputCondition.get();
        if (handler != null) {
            return handler.component.getStructureLevel();
        }
        return null;
    }
}

