/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.common.structure.type.premade;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import team.creative.creativecore.client.render.box.RenderBox;
import team.creative.creativecore.common.level.IOrientatedLevel;
import team.creative.creativecore.common.util.math.base.Facing;
import team.creative.creativecore.common.util.math.transformation.Rotation;
import team.creative.creativecore.common.util.math.vec.Vec3d;
import team.creative.creativecore.common.util.mc.ColorUtils;
import team.creative.littletiles.LittleTilesGuiRegistry;
import team.creative.littletiles.LittleTilesRegistry;
import team.creative.littletiles.common.block.little.tile.LittleTileContext;
import team.creative.littletiles.common.block.little.tile.group.LittleGroup;
import team.creative.littletiles.common.block.little.tile.parent.IStructureParentCollection;
import team.creative.littletiles.common.entity.particle.LittleParticle;
import team.creative.littletiles.common.entity.particle.LittleParticlePresets;
import team.creative.littletiles.common.entity.particle.LittleParticleTexture;
import team.creative.littletiles.common.item.ItemLittleWrench;
import team.creative.littletiles.common.math.box.LittleBox;
import team.creative.littletiles.common.placement.box.LittlePlaceBox;
import team.creative.littletiles.common.placement.box.LittlePlaceBoxFacing;
import team.creative.littletiles.common.structure.attribute.LittleAttributeBuilder;
import team.creative.littletiles.common.structure.directional.StructureDirectional;
import team.creative.littletiles.common.structure.type.premade.LittleStructurePremade;

public class LittleParticleEmitter
extends LittleStructurePremade {
    @StructureDirectional
    public Facing facing = Facing.UP;
    public ParticleSettings settings = new ParticleSettings();
    public ParticleSpread spread = new ParticleSpreadRandom();
    public int delay = 10;
    public int count = 1;
    protected int ticker = 0;
    private static List<Function<CompoundTag, ParticleSpread>> parser = new ArrayList<Function<CompoundTag, ParticleSpread>>();

    public LittleParticleEmitter(LittleStructureTypeParticleEmitter type, IStructureParentCollection mainBlock) {
        super(type, mainBlock);
    }

    @Override
    public void tick() {
        if (this.getOutput(0).getState().any()) {
            return;
        }
        if (this.ticker >= this.delay) {
            if (this.isClient()) {
                for (int i = 0; i < this.count; ++i) {
                    this.spawnParticle(this.getStructureLevel());
                }
            }
            this.ticker = 0;
        } else {
            ++this.ticker;
        }
    }

    @Override
    public boolean canInteract() {
        return true;
    }

    @Override
    public InteractionResult use(Level level, LittleTileContext context, BlockPos pos, Player player, BlockHitResult result) {
        if (!level.isClientSide) {
            LittleTilesGuiRegistry.PARTICLE.open(player, this);
        }
        return InteractionResult.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticle(Level level) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player.getMainHandItem().getItem() instanceof ItemLittleWrench || mc.player.getOffhandItem().getItem() instanceof ItemLittleWrench) {
            return;
        }
        try {
            AABB bb = this.getSurroundingBox().getAABB();
            Vec3d pos = new Vec3d(0.0, 0.5, 0.0);
            Vec3d speed = this.spread.generate();
            Rotation rotation = null;
            switch (this.facing) {
                case DOWN: {
                    pos.scale(-1.0);
                    speed.scale(-1.0);
                    break;
                }
                case EAST: {
                    rotation = Rotation.Z_COUNTER_CLOCKWISE;
                    break;
                }
                case WEST: {
                    rotation = Rotation.Z_CLOCKWISE;
                    break;
                }
                case SOUTH: {
                    rotation = Rotation.X_CLOCKWISE;
                    break;
                }
                case NORTH: {
                    rotation = Rotation.X_COUNTER_CLOCKWISE;
                    break;
                }
                case UP: {
                    break;
                }
            }
            if (rotation != null) {
                rotation.transform(pos);
                rotation.transform(speed);
            }
            pos.x *= bb.maxX - bb.minX;
            pos.y *= bb.maxY - bb.minY;
            pos.z *= bb.maxZ - bb.minZ;
            pos.x += (bb.minX + bb.maxX) / 2.0;
            pos.y += (bb.minY + bb.maxY) / 2.0;
            pos.z += (bb.minZ + bb.maxZ) / 2.0;
            if (level instanceof IOrientatedLevel) {
                ((IOrientatedLevel)level).getOrigin().transformPointToWorld(pos);
                ((IOrientatedLevel)level).getOrigin().onlyRotateWithoutCenter(speed);
            }
            mc.particleEngine.add((Particle)new LittleParticle((ClientLevel)level, pos, speed, this.settings));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void loadSettings(CompoundTag nbt) {
        this.spread = LittleParticleEmitter.loadSpread(nbt);
        this.delay = nbt.contains("tickDelay") ? nbt.getInt("tickDelay") : 10;
        this.ticker = nbt.getInt("ticker");
        this.count = nbt.contains("tickCount") ? nbt.getInt("tickCount") : 1;
        this.settings = nbt.contains("settings") ? new ParticleSettings(nbt.getCompound("settings")) : LittleParticlePresets.SMOKE.settings.copy();
    }

    @Override
    protected void loadExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        this.loadSettings(nbt);
    }

    @Override
    protected void saveExtra(CompoundTag nbt, HolderLookup.Provider provider) {
        nbt.putInt("tickDelay", this.delay);
        nbt.putInt("tickCount", this.count);
        nbt.putInt("ticker", this.ticker);
        this.spread.write(nbt);
        CompoundTag settingsData = new CompoundTag();
        this.settings.write(settingsData);
        nbt.put("settings", (Tag)settingsData);
    }

    public static ParticleSpread loadSpread(CompoundTag nbt) {
        ParticleSpread spread = null;
        for (int i = parser.size() - 1; i >= 0 && (spread = parser.get(i).apply(nbt)) == null; --i) {
        }
        if (spread == null) {
            spread = new ParticleSpreadRandom();
        }
        spread.speedY = nbt.getFloat("speedY");
        spread.spread = nbt.getFloat("spread");
        return spread;
    }

    public static void registerParticleSpreadParser(Function<CompoundTag, ParticleSpread> function) {
        parser.add(function);
    }

    static {
        LittleParticleEmitter.registerParticleSpreadParser(x -> {
            ParticleSpreadRandom spread = new ParticleSpreadRandom();
            spread.speedX = x.getFloat("speedX");
            spread.speedZ = x.getFloat("speedZ");
            return spread;
        });
        LittleParticleEmitter.registerParticleSpreadParser(x -> {
            if (!x.contains("radius")) {
                return null;
            }
            ParticleSpreadCircular spread = new ParticleSpreadCircular();
            spread.radius = x.getFloat("radius");
            spread.angle = x.getFloat("angle");
            spread.steps = x.getInt("steps");
            return spread;
        });
    }

    public static class ParticleSettings {
        public float gravity = 0.0f;
        public int color = ColorUtils.rgba((int)20, (int)20, (int)20, (int)255);
        public int lifetime = 40;
        public int lifetimeDeviation = 5;
        public float startSize = 0.1f;
        public float endSize = 0.1f;
        public float sizeDeviation = 0.02f;
        public LittleParticleTexture texture = LittleParticleTexture.dust_fade_out;
        public boolean randomColor = false;
        public boolean collision = true;

        public ParticleSettings() {
        }

        public ParticleSettings(float gravity, int color, int lifetime, int lifetimeDeviation, float startSize, float endSize, float sizeDeviation, LittleParticleTexture texture, boolean randomColor, boolean collision) {
            this.gravity = gravity;
            this.color = color;
            this.lifetime = lifetime;
            this.lifetimeDeviation = lifetimeDeviation;
            this.startSize = startSize;
            this.endSize = endSize;
            this.sizeDeviation = sizeDeviation;
            this.texture = texture;
            this.randomColor = randomColor;
            this.collision = collision;
        }

        public ParticleSettings(CompoundTag nbt) {
            this.gravity = nbt.getFloat("gravity");
            this.color = nbt.getInt("color");
            this.lifetime = nbt.getInt("lifetime");
            this.lifetimeDeviation = nbt.getInt("lifetimeDeviation");
            this.startSize = nbt.getFloat("startSize");
            this.endSize = nbt.getFloat("endSize");
            this.sizeDeviation = nbt.getFloat("sizeDeviation");
            this.randomColor = nbt.getBoolean("randomColor");
            this.collision = nbt.getBoolean("collision");
            this.texture = LittleParticleTexture.get(nbt.getString("texture"));
        }

        public void write(CompoundTag nbt) {
            nbt.putFloat("gravity", this.gravity);
            nbt.putInt("color", this.color);
            nbt.putInt("lifetime", this.lifetime);
            nbt.putInt("lifetimeDeviation", this.lifetimeDeviation);
            nbt.putFloat("startSize", this.startSize);
            nbt.putFloat("endSize", this.endSize);
            nbt.putFloat("sizeDeviation", this.sizeDeviation);
            nbt.putString("texture", this.texture.name());
            nbt.putBoolean("randomColor", this.randomColor);
            nbt.putBoolean("collision", this.collision);
        }

        public ParticleSettings copy() {
            return new ParticleSettings(this.gravity, this.color, this.lifetime, this.lifetimeDeviation, this.startSize, this.endSize, this.sizeDeviation, this.texture, this.randomColor, this.collision);
        }
    }

    public static class ParticleSpreadRandom
    extends ParticleSpread {
        public float speedX = 0.0f;
        public float speedZ = 0.0f;

        public ParticleSpreadRandom() {
        }

        public ParticleSpreadRandom(float power, float x, float z, float deviation) {
            this.speedY = power;
            this.speedX = x;
            this.speedZ = z;
            this.spread = deviation;
        }

        @Override
        protected void populate(Vec3d vec) {
            vec.x = this.speedX;
            vec.z = this.speedZ;
        }

        @Override
        public void write(CompoundTag nbt) {
            super.write(nbt);
            nbt.putFloat("speedX", this.speedX);
            nbt.putFloat("speedZ", this.speedZ);
        }
    }

    public static abstract class ParticleSpread {
        public float speedY = 0.1f;
        public float spread = 0.1f;

        protected abstract void populate(Vec3d var1);

        public Vec3d generate() {
            Vec3d vec = new Vec3d();
            vec.y = this.speedY;
            this.populate(vec);
            float half = this.spread / 2.0f;
            vec.x += Math.random() * (double)this.spread - (double)half;
            vec.z += Math.random() * (double)this.spread - (double)half;
            return vec;
        }

        public void write(CompoundTag nbt) {
            nbt.putFloat("speedY", this.speedY);
            nbt.putFloat("spread", this.spread);
        }
    }

    public static class ParticleSpreadCircular
    extends ParticleSpread {
        public float radius = 0.1f;
        public float angle = 0.0f;
        public int steps = 30;

        public ParticleSpreadCircular() {
        }

        public ParticleSpreadCircular(float power, float radius, float angle, int steps, float deviation) {
            this.speedY = power;
            this.radius = radius;
            this.angle = angle;
            this.steps = steps;
            this.spread = deviation;
        }

        @Override
        protected void populate(Vec3d vec) {
            vec.x = Math.cos(this.angle) * (double)this.radius;
            vec.z = Math.sin(this.angle) * (double)this.radius;
            this.angle = (float)((double)this.angle + Math.PI * 2 / (double)this.steps);
        }

        @Override
        public void write(CompoundTag nbt) {
            super.write(nbt);
            nbt.putFloat("radius", this.radius);
            nbt.putFloat("degree", this.angle);
            nbt.putInt("steps", this.steps);
        }
    }

    public static class LittleStructureTypeParticleEmitter
    extends LittleStructurePremade.LittlePremadeType {
        @OnlyIn(value=Dist.CLIENT)
        public List<RenderBox> cubes;

        public <T extends LittleParticleEmitter> LittleStructureTypeParticleEmitter(String id, Class<T> structureClass, BiFunction<LittleStructureTypeParticleEmitter, IStructureParentCollection, T> factory, LittleAttributeBuilder attribute, String modid) {
            super(id, structureClass, factory, attribute, modid);
        }

        @Override
        public List<LittlePlaceBox> getSpecialBoxes(LittleGroup group) {
            List<LittlePlaceBox> result = super.getSpecialBoxes(group);
            Facing facing = (Facing)this.loadDirectional(group, "facing");
            LittleBox box = group.getSurroundingBox();
            result.add(new LittlePlaceBoxFacing(box, facing, -65536));
            return result;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public List<RenderBox> getItemPreview(LittleGroup previews, boolean translucent) {
            if (this.cubes == null) {
                this.cubes = new ArrayList<RenderBox>();
                this.cubes.add(new RenderBox(0.2f, 0.2f, 0.2f, 0.8f, 0.8f, 0.8f, ((Block)LittleTilesRegistry.CLEAN.value()).defaultBlockState()).setColor(-13619152));
            }
            return this.cubes;
        }

        @Override
        public boolean canSnapToGrid() {
            return false;
        }
    }
}

