/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.common.level;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import team.creative.creativecore.common.util.math.box.BoxesVoxelShape;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements LevelAccessor,
AutoCloseable {
    public boolean noCollision(@Nullable Entity entity, AABB bb) {
        for (VoxelShape voxelshape : this.getBlockCollisions(entity, bb)) {
            BoxesVoxelShape box;
            if (!(voxelshape instanceof BoxesVoxelShape ? (box = (BoxesVoxelShape)voxelshape).intersectsWith(bb) : !voxelshape.isEmpty())) continue;
            return false;
        }
        if (!this.getEntityCollisions(entity, bb).isEmpty()) {
            return false;
        }
        if (entity == null) {
            return true;
        }
        VoxelShape voxelshape1 = this.borderCollision(entity, bb);
        return voxelshape1 == null || !Shapes.joinIsNotEmpty((VoxelShape)voxelshape1, (VoxelShape)Shapes.create((AABB)bb), (BooleanOp)BooleanOp.AND);
    }

    @Nullable
    private VoxelShape borderCollision(Entity p_186441_, AABB p_186442_) {
        WorldBorder worldborder = this.getWorldBorder();
        return worldborder.isInsideCloseToBorder(p_186441_, p_186442_) ? worldborder.getCollisionShape() : null;
    }

    public Optional<Vec3> findFreePosition(@Nullable Entity entity, VoxelShape shape, Vec3 vec, double x, double y, double z) {
        if (shape.isEmpty()) {
            return Optional.empty();
        }
        AABB aabb = shape.bounds().inflate(x, y, z);
        ArrayList shapes = Lists.newArrayList((Iterable)this.getBlockCollisions(entity, aabb));
        for (VoxelShape toTest2 : shapes) {
            if (!(toTest2 instanceof BoxesVoxelShape)) continue;
            BoxesVoxelShape box = (BoxesVoxelShape)toTest2;
            box.onlyKeepIntersecting(aabb);
        }
        VoxelShape voxelshape = shapes.stream().filter(toTest -> this.getWorldBorder() == null || this.getWorldBorder().isWithinBounds(toTest.bounds())).flatMap(toTest -> toTest.toAabbs().stream()).map(bb -> bb.inflate(x / 2.0, y / 2.0, z / 2.0)).map(Shapes::create).reduce(Shapes.empty(), Shapes::or);
        VoxelShape voxelshape1 = Shapes.join((VoxelShape)shape, (VoxelShape)voxelshape, (BooleanOp)BooleanOp.ONLY_FIRST);
        return voxelshape1.closestPointTo(vec);
    }
}

