/*
 * Decompiled with CFR 0.152.
 */
package team.creative.littletiles.mixin.sodium;

import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import net.caffeinemc.mods.sodium.client.gl.arena.GlBufferSegment;
import net.caffeinemc.mods.sodium.client.gl.arena.PendingUpload;
import net.caffeinemc.mods.sodium.client.gl.attribute.GlVertexFormat;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBufferTarget;
import net.caffeinemc.mods.sodium.client.gl.device.CommandList;
import net.caffeinemc.mods.sodium.client.gl.device.RenderDevice;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.render.SodiumWorldRenderer;
import net.caffeinemc.mods.sodium.client.render.chunk.ChunkUpdateType;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSection;
import net.caffeinemc.mods.sodium.client.render.chunk.RenderSectionManager;
import net.caffeinemc.mods.sodium.client.render.chunk.data.BuiltSectionMeshParts;
import net.caffeinemc.mods.sodium.client.render.chunk.data.SectionRenderDataStorage;
import net.caffeinemc.mods.sodium.client.render.chunk.region.RenderRegion;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.material.DefaultMaterials;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.SortType;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.TranslucentGeometryCollector;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.CombinedCameraPos;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.PresentTranslucentData;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.Sorter;
import net.caffeinemc.mods.sodium.client.render.chunk.translucent_sorting.data.TranslucentData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import org.lwjgl.opengl.GL15C;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.map.ChunkLayerMap;
import team.creative.littletiles.LittleTiles;
import team.creative.littletiles.client.mod.sodium.SodiumSectionCameraPos;
import team.creative.littletiles.client.mod.sodium.buffer.SodiumAppendChunkBufferUploader;
import team.creative.littletiles.client.mod.sodium.buffer.SodiumChunkBufferDownloader;
import team.creative.littletiles.client.render.cache.LayeredBufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCache;
import team.creative.littletiles.client.render.cache.buffer.BufferCollection;
import team.creative.littletiles.client.render.mc.RenderChunkExtender;
import team.creative.littletiles.client.render.mc.VertexBufferExtender;
import team.creative.littletiles.mixin.sodium.ChunkBuildBuffersAccessor;
import team.creative.littletiles.mixin.sodium.ChunkBuilderAccessor;
import team.creative.littletiles.mixin.sodium.GLRenderDeviceAccessor;
import team.creative.littletiles.mixin.sodium.GlBufferSegmentAccessor;
import team.creative.littletiles.mixin.sodium.RenderSectionManagerAccessor;
import team.creative.littletiles.mixin.sodium.SectionRenderDataStorageAccessor;
import team.creative.littletiles.mixin.sodium.SodiumWorldRendererAccessor;
import team.creative.littletiles.mixin.sodium.TranslucentGeometryCollectorAccessor;

@Mixin(value={RenderSection.class})
public abstract class RenderSectionMixin
implements RenderChunkExtender {
    @Shadow(remap=false)
    @Final
    private int sectionIndex;
    @Shadow(remap=false)
    @Final
    private int chunkX;
    @Shadow(remap=false)
    @Final
    private int chunkY;
    @Shadow(remap=false)
    @Final
    private int chunkZ;
    @Shadow(remap=false)
    private TextureAtlasSprite[] animatedSprites;
    @Shadow(remap=false)
    private boolean built;
    @Shadow(remap=false)
    private int flags;
    @Unique
    private BlockPos origin;
    @Unique
    private volatile int queued;
    @Unique
    public volatile ChunkLayerMap<BufferCollection> lastUploaded;

    @Override
    public int getQueued() {
        return this.queued;
    }

    @Override
    public void setQueued(int queued) {
        this.queued = queued;
    }

    @Override
    public ChunkLayerMap<BufferCollection> getLastUploaded() {
        return this.lastUploaded;
    }

    @Override
    public void setLastUploaded(ChunkLayerMap<BufferCollection> uploaded) {
        this.lastUploaded = uploaded;
    }

    @Override
    public VertexBuffer getVertexBuffer(RenderType layer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void markReadyForUpdate(boolean playerChanged) {
        Minecraft.getInstance().submit(() -> {
            if (!((RenderSection)this).isBuilt()) {
                ((RenderSection)this).setPendingUpdate(ChunkUpdateType.REBUILD);
            } else {
                SodiumWorldRenderer.instance().scheduleRebuildForChunk(this.chunkX, this.chunkY, this.chunkZ, playerChanged);
                RenderSectionManager manager = ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager();
                manager.markGraphDirty();
            }
        });
    }

    @Override
    public VertexSorting createVertexSorting(double x, double y, double z) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty(RenderType layer) {
        return this.getUploadedBuffer(this.getStorage(this.getRenderRegion(), layer)) == null;
    }

    @Override
    public MeshData.SortState getTransparencyState() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHasBlock(RenderType layer) {
        throw new UnsupportedOperationException();
    }

    public GlBufferSegment getUploadedBuffer(SectionRenderDataStorage storage) {
        SectionRenderDataStorageAccessor s = (SectionRenderDataStorageAccessor)storage;
        if (s == null) {
            return null;
        }
        return s.getVertexAllocations()[this.sectionIndex];
    }

    public SectionRenderDataStorage getStorage(RenderRegion region, RenderType layer) {
        return region.getStorage(DefaultMaterials.forRenderLayer((RenderType)layer).pass);
    }

    public RenderRegion getRenderRegion() {
        return ((RenderSectionManagerAccessor)((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager()).getRegions().createForChunk(this.chunkX, this.chunkY, this.chunkZ);
    }

    @Override
    public synchronized void prepareUpload() {
        this.backToRAM();
        RenderChunkExtender.super.prepareUpload();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer downloadUploadedData(VertexBufferExtender buffer, long offset, int size) {
        boolean active = ((GLRenderDeviceAccessor)RenderDevice.INSTANCE).getIsActive();
        if (!active) {
            RenderDevice.enterManagedCode();
        }
        try {
            RenderDevice.INSTANCE.createCommandList().bindBuffer(GlBufferTarget.ARRAY_BUFFER, (GlBuffer)buffer);
            ByteBuffer result = ByteBuffer.allocateDirect(size);
            GL15C.glGetBufferSubData((int)GlBufferTarget.ARRAY_BUFFER.getTargetParameter(), (long)offset, (ByteBuffer)result);
            ByteBuffer byteBuffer = result;
            return byteBuffer;
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            if (!(e instanceof IllegalStateException)) {
                e.printStackTrace();
            }
            ByteBuffer byteBuffer = null;
            return byteBuffer;
        }
        finally {
            if (!active) {
                RenderDevice.exitManagedCode();
            }
        }
    }

    public ByteBuffer downloadSegment(GlBufferSegment segment, GlVertexFormat format) {
        GlBuffer buffer = ((GlBufferSegmentAccessor)segment).getArena().getBufferObject();
        return this.downloadUploadedData((VertexBufferExtender)buffer, segment.getOffset() * (long)format.getStride(), (int)(segment.getLength() * (long)format.getStride()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backToRAM() {
        block7: {
            RenderRegion region = this.getRenderRegion();
            ChunkLayerMap<BufferCollection> caches = this.getLastUploaded();
            if (caches == null) {
                return;
            }
            Runnable run = () -> {
                SodiumChunkBufferDownloader downloader = new SodiumChunkBufferDownloader();
                RenderSectionManager manager = ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager();
                ChunkBuilderAccessor chunkBuilder = (ChunkBuilderAccessor)manager.getBuilder();
                GlVertexFormat format = ((ChunkBuildBuffersAccessor)chunkBuilder.getLocalContext().buffers).getVertexType().getVertexFormat();
                for (Tuple tuple : caches.tuples()) {
                    GlBufferSegment segment;
                    SectionRenderDataStorage storage = region.getStorage(DefaultMaterials.forRenderLayer((RenderType)((RenderType)tuple.key)).pass);
                    if (storage == null || (segment = this.getUploadedBuffer(storage)) == null) continue;
                    ByteBuffer vertexData = this.downloadSegment(segment, format);
                    if (vertexData == null) {
                        ((BufferCollection)tuple.value).discard();
                        continue;
                    }
                    downloader.set(storage.getDataPointer(this.sectionIndex), format, segment.getOffset(), vertexData);
                    ((BufferCollection)tuple.value).download(downloader);
                    downloader.clear();
                }
                this.setLastUploaded(null);
            };
            try {
                if (Minecraft.getInstance().isSameThread()) {
                    run.run();
                    break block7;
                }
                RenderSectionMixin renderSectionMixin = this;
                synchronized (renderSectionMixin) {
                    CompletableFuture.runAsync(run, (Executor)Minecraft.getInstance()).join();
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public boolean appendRenderData(Iterable<? extends LayeredBufferCache> blocks) {
        RenderSectionManager manager = ((SodiumWorldRendererAccessor)SodiumWorldRenderer.instance()).getRenderSectionManager();
        RenderRegion region = this.getRenderRegion();
        ChunkBuilderAccessor chunkBuilder = (ChunkBuilderAccessor)manager.getBuilder();
        GlVertexFormat format = ((ChunkBuildBuffersAccessor)chunkBuilder.getLocalContext().buffers).getVertexType().getVertexFormat();
        SodiumAppendChunkBufferUploader uploader = new SodiumAppendChunkBufferUploader();
        for (RenderType layer : RenderType.CHUNK_BUFFER_LAYERS) {
            int size = 0;
            for (LayeredBufferCache layeredBufferCache : blocks) {
                size += layeredBufferCache.length(layer);
            }
            if (size == 0) continue;
            TerrainRenderPass pass = DefaultMaterials.forRenderLayer((RenderType)layer).pass;
            SectionRenderDataStorage sectionRenderDataStorage = region.createStorage(pass);
            GlBufferSegment segment = this.getUploadedBuffer(sectionRenderDataStorage);
            ByteBuffer vanillaBuffer = null;
            if (segment != null) {
                vanillaBuffer = this.downloadSegment(segment, format);
            }
            if (segment == null) {
                LittleTiles.LOGGER.error("Failed to download chunk data. chunk: {}, layer: {}", (Object)this, (Object)layer);
                continue;
            }
            int[] extraLengthFacing = new int[ModelQuadFacing.COUNT];
            for (LayeredBufferCache layeredBufferCache : blocks) {
                for (int i = 0; i < extraLengthFacing.length; ++i) {
                    int n = i;
                    extraLengthFacing[n] = extraLengthFacing[n] + layeredBufferCache.length(layer, i);
                }
            }
            uploader.set(sectionRenderDataStorage.getDataPointer(this.sectionIndex), format, segment.getOffset(), vanillaBuffer, size, extraLengthFacing, null);
            if (layer == RenderType.translucent()) {
                uploader.setTranslucentCollector(new TranslucentGeometryCollector(((RenderSection)this).getPosition()));
                if (vanillaBuffer != null) {
                    uploader.appendVanillaTranslucentData(vanillaBuffer);
                }
            }
            if (segment != null) {
                sectionRenderDataStorage.removeVertexData(this.sectionIndex);
            }
            for (LayeredBufferCache layeredBufferCache : blocks) {
                BufferCache cache = (BufferCache)layeredBufferCache.get(layer);
                if (cache == null || !cache.isAvailable()) continue;
                cache.upload(uploader);
            }
            boolean active = ((GLRenderDeviceAccessor)RenderDevice.INSTANCE).getIsActive();
            if (!active) {
                RenderDevice.enterManagedCode();
            }
            PendingUpload pendingUpload = new PendingUpload(uploader.buffer());
            CommandList commandList = RenderDevice.INSTANCE.createCommandList();
            RenderRegion.DeviceResources resources = region.createResources(commandList);
            if (resources.getGeometryArena().upload(commandList, Stream.of(pendingUpload))) {
                region.refreshTesselation(commandList);
            }
            sectionRenderDataStorage.setVertexData(this.sectionIndex, pendingUpload.getResult(), uploader.ranges());
            if (layer == RenderType.translucent()) {
                SodiumSectionCameraPos cam = new SodiumSectionCameraPos(((RenderSectionManagerAccessor)manager).getCameraPosition(), ((RenderSection)this).getOriginX(), ((RenderSection)this).getOriginY(), ((RenderSection)this).getOriginZ());
                uploader.getTranslucentCollector().finishRendering();
                ((TranslucentGeometryCollectorAccessor)uploader.getTranslucentCollector()).setSortType(SortType.NONE);
                BuiltSectionMeshParts mesh = new BuiltSectionMeshParts(uploader.buffer(), uploader.ranges());
                TranslucentData oldData = ((RenderSection)this).getTranslucentData();
                TranslucentData data = uploader.getTranslucentCollector().getTranslucentData(oldData, mesh, (CombinedCameraPos)cam);
                if (oldData != null) {
                    sectionRenderDataStorage.removeIndexData(this.sectionIndex);
                }
                if (data instanceof PresentTranslucentData) {
                    PresentTranslucentData d = (PresentTranslucentData)data;
                    Sorter sorter = d.getSorter();
                    sorter.writeIndexBuffer((CombinedCameraPos)cam, true);
                    PendingUpload indexUpload = new PendingUpload(sorter.getIndexBuffer());
                    if (resources.getIndexArena().upload(commandList, Stream.of(indexUpload))) {
                        region.refreshIndexedTesselation(commandList);
                    }
                    sectionRenderDataStorage.setIndexData(this.sectionIndex, indexUpload.getResult());
                    ((RenderSectionManagerAccessor)manager).getSortTriggering().integrateTranslucentData(oldData, data, cam.getAbsoluteCameraPos(), (arg_0, arg_1) -> ((RenderSectionManager)manager).scheduleSort(arg_0, arg_1));
                    ((RenderSection)this).setTranslucentData(data);
                    sorter.getIndexBuffer().free();
                }
            }
            if (!active) {
                RenderDevice.exitManagedCode();
            }
            uploader.clear();
        }
        this.animatedSprites = uploader.sprites();
        this.built = true;
        this.flags |= 1;
        return true;
    }
}

