/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class ModelDragonFeet<T extends Entity>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"voidsmith", (String)"model_dragon_feet"), "main");
    public final ModelPart bipedLeftLeg;
    public final ModelPart armorLeftLeg;
    public final ModelPart armorLeftBoot;
    public final ModelPart bipedRightLeg;
    public final ModelPart armorRightLeg;
    public final ModelPart armorRightBoot;

    public ModelDragonFeet(ModelPart root) {
        this.bipedLeftLeg = root.getChild("bipedLeftLeg");
        this.armorLeftLeg = this.bipedLeftLeg.getChild("armorLeftLeg");
        this.armorLeftBoot = this.bipedLeftLeg.getChild("armorLeftBoot");
        this.bipedRightLeg = root.getChild("bipedRightLeg");
        this.armorRightLeg = this.bipedRightLeg.getChild("armorRightLeg");
        this.armorRightBoot = this.bipedRightLeg.getChild("armorRightBoot");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition bipedLeftLeg = partdefinition.addOrReplaceChild("bipedLeftLeg", CubeListBuilder.create(), PartPose.offset((float)2.0f, (float)20.0f, (float)0.0f));
        PartDefinition armorLeftLeg = bipedLeftLeg.addOrReplaceChild("armorLeftLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition armorLeftBoot = bipedLeftLeg.addOrReplaceChild("armorLeftBoot", CubeListBuilder.create().texOffs(32, 62).addBox(-2.5f, 7.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).texOffs(72, 12).addBox(-1.5f, 10.5f, -3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(30, 72).addBox(0.5f, 10.5f, -3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition bipedRightLeg = partdefinition.addOrReplaceChild("bipedRightLeg", CubeListBuilder.create(), PartPose.offset((float)-2.0f, (float)20.0f, (float)0.0f));
        PartDefinition armorRightLeg = bipedRightLeg.addOrReplaceChild("armorRightLeg", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        PartDefinition armorRightBoot = bipedRightLeg.addOrReplaceChild("armorRightBoot", CubeListBuilder.create().texOffs(60, 32).addBox(-1.5f, 10.5f, -3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(72, 9).addBox(0.5f, 10.5f, -3.5f, 1.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)).texOffs(52, 62).addBox(-2.5f, 7.5f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-8.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgb) {
        this.bipedLeftLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
        this.bipedRightLeg.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgb);
    }
}

