/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.item;

import java.util.List;
import net.mcreator.voidsmith.procedures.KhopeshEndBall;
import net.mcreator.voidsmith.procedures.KhopeshLivingEntityIsHitWithToolProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class KhopeshItem
extends SwordItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 20316;
        }

        public float getSpeed() {
            return 36.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 45;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.AMETHYST_SHARD)});
        }
    };

    public KhopeshItem() {
        super(TOOL_TIER, new Item.Properties().attributes(SwordItem.createAttributes((Tier)TOOL_TIER, (float)17.0f, (float)-0.8f)).fireResistant());
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"Powers:"));
        list.add((Component)Component.translatable((String)"1. Bleeding! if you hit any entity with this sword it will remove 30% of it's health for a short period of time!"));
        list.add((Component)Component.translatable((String)"2. Sneaking and right clicking launches an ender dragon fire ball!"));
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        KhopeshLivingEntityIsHitWithToolProcedure.execute((LevelAccessor)entity.level(), (Entity)entity);
        return retval;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        ItemStack itemstack = entity.getItemInHand(hand);
        InteractionResultHolder ar = super.use(world, entity, hand);
        ItemStack retval = (ItemStack)ar.getObject();
        if (entity.isShiftKeyDown()) {
            KhopeshEndBall.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
            return InteractionResultHolder.success((Object)retval);
        }
        return ar;
    }
}

