/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.item;

import java.util.List;
import net.mcreator.voidsmith.procedures.MattockBlockDestroyedWithToolProcedure;
import net.mcreator.voidsmith.procedures.MattockTorchPlace;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class MattockItem
extends PickaxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 20316;
        }

        public float getSpeed() {
            return 36.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 45;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.AMETHYST_SHARD)});
        }
    };

    public MattockItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)12.0f, (float)-1.2f)).fireResistant());
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"Powers:"));
        list.add((Component)Component.translatable((String)"1. Veinminer! it will automatically mein a large vein of ores!"));
        list.add((Component)Component.translatable((String)"2. Breaking a block while sneaking causes a large area of the same type of block to be broken!"));
        list.add((Component)Component.translatable((String)"3. Right clicking on a block will place a torch! no cost!"));
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        boolean result = super.mineBlock(stack, world, state, pos, entityLiving);
        if (!world.isClientSide() && entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            MattockBlockDestroyedWithToolProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)player);
        }
        return result;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player entityLiving = context.getPlayer();
        if (!world.isClientSide() && entityLiving instanceof Player) {
            Player player = entityLiving;
            MattockTorchPlace.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)player);
        }
        return super.useOn(context);
    }
}

