/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.item;

import java.util.List;
import net.mcreator.voidsmith.procedures.SpadedBlockDestroyedWithToolProcedure;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class SpadedItem
extends ShovelItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 20316;
        }

        public float getSpeed() {
            return 36.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_GOLD_TOOL;
        }

        public int getEnchantmentValue() {
            return 45;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)Items.AMETHYST_SHARD)});
        }
    };

    public SpadedItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)9.0f, (float)-1.9f)).fireResistant());
    }

    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.translatable((String)"Powers:"));
        list.add((Component)Component.translatable((String)"1. It can dig up buried treasure chest loot at random!"));
        list.add((Component)Component.translatable((String)"2. If you break a block while sneaking it will flatten a large area around you!"));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        SpadedBlockDestroyedWithToolProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack);
        return retval;
    }
}

