/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.procedures;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.DragonFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class KhopeshEndBall {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (entity == null || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (!player.getCooldowns().isOnCooldown(itemstack.getItem()) && world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            Vec3 lookVector = player.getLookAngle().normalize();
            double spawnX = x + lookVector.x * 1.5;
            double spawnY = y + (double)player.getEyeHeight() + lookVector.y * 1.5;
            double spawnZ = z + lookVector.z * 1.5;
            DragonFireball fireball = new DragonFireball((Level)serverLevel, (LivingEntity)player, lookVector);
            fireball.setPos(spawnX, spawnY, spawnZ);
            fireball.setOwner((Entity)player);
            serverLevel.addFreshEntity((Entity)fireball);
            player.getCooldowns().addCooldown(itemstack.getItem(), 100);
        }
    }
}

