/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.procedures;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class LabhrysBlockDestroyedWithToolProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        if (entity == null || !entity.isShiftKeyDown()) {
            return;
        }
        BlockPos startPos = new BlockPos((int)x, (int)y, (int)z);
        BlockState startState = level.getBlockState(startPos);
        if (!LabhrysBlockDestroyedWithToolProcedure.isLogBlock(startState.getBlock())) {
            return;
        }
        HashSet<BlockPos> brokenLogs = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(startPos);
        while (!toCheck.isEmpty()) {
            Object state;
            BlockPos currentPos = (BlockPos)toCheck.poll();
            if (brokenLogs.contains(currentPos) || !LabhrysBlockDestroyedWithToolProcedure.isLogBlock((state = level.getBlockState(currentPos)).getBlock())) continue;
            brokenLogs.add(currentPos);
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos neighbor;
                        if (dx == 0 && dy == 0 && dz == 0 || brokenLogs.contains(neighbor = currentPos.offset(dx, dy, dz))) continue;
                        toCheck.add(neighbor);
                    }
                }
            }
        }
        level.playSound(null, startPos, SoundEvents.WITHER_BREAK_BLOCK, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (BlockPos currentPos : brokenLogs) {
                BlockState state = level.getBlockState(currentPos);
                List drops = Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)currentPos, null);
                for (ItemStack stack : drops) {
                    serverLevel.addFreshEntity((Entity)new ItemEntity((Level)serverLevel, (double)startPos.getX() + 0.5, (double)startPos.getY() + 0.5, (double)startPos.getZ() + 0.5, stack));
                }
                level.setBlock(currentPos, Blocks.AIR.defaultBlockState(), 3);
            }
        }
        for (BlockPos logPos : brokenLogs) {
            for (BlockPos offset : BlockPos.betweenClosed((BlockPos)logPos.offset(-4, -4, -4), (BlockPos)logPos.offset(4, 4, 4))) {
                BlockState leafState = level.getBlockState(offset.immutable());
                if (!LabhrysBlockDestroyedWithToolProcedure.isLeafBlock(leafState.getBlock())) continue;
                boolean hasNearbyLogs = false;
                for (BlockPos nearby : BlockPos.betweenClosed((BlockPos)offset.offset(-4, -4, -4), (BlockPos)offset.offset(4, 4, 4))) {
                    Block block = level.getBlockState(nearby.immutable()).getBlock();
                    if (!LabhrysBlockDestroyedWithToolProcedure.isLogBlock(block) || brokenLogs.contains(nearby.immutable())) continue;
                    hasNearbyLogs = true;
                    break;
                }
                if (hasNearbyLogs) continue;
                level.scheduleTick(offset.immutable(), leafState.getBlock(), 1);
            }
        }
    }

    private static boolean isLogBlock(Block block) {
        return block == Blocks.OAK_LOG || block == Blocks.SPRUCE_LOG || block == Blocks.BIRCH_LOG || block == Blocks.JUNGLE_LOG || block == Blocks.ACACIA_LOG || block == Blocks.DARK_OAK_LOG || block == Blocks.MANGROVE_LOG || block == Blocks.CHERRY_LOG || block == Blocks.CRIMSON_STEM || block == Blocks.WARPED_STEM;
    }

    private static boolean isLeafBlock(Block block) {
        return block == Blocks.OAK_LEAVES || block == Blocks.SPRUCE_LEAVES || block == Blocks.BIRCH_LEAVES || block == Blocks.JUNGLE_LEAVES || block == Blocks.ACACIA_LEAVES || block == Blocks.DARK_OAK_LEAVES || block == Blocks.MANGROVE_LEAVES || block == Blocks.CHERRY_LEAVES || block == Blocks.WARPED_WART_BLOCK || block == Blocks.NETHER_WART_BLOCK;
    }
}

