/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.procedures;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class MattockBlockDestroyedWithToolProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        if (entity == null || !(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ItemStack tool = player.getMainHandItem();
        if (tool.isEmpty()) {
            return;
        }
        BlockPos startPos = new BlockPos((int)x, (int)y, (int)z);
        BlockState initialBlockState = world.getBlockState(startPos);
        Block initialBlock = initialBlockState.getBlock();
        if (initialBlockState.isAir() || initialBlock == Blocks.BEDROCK) {
            return;
        }
        if (!(world instanceof Level)) {
            return;
        }
        Level level = (Level)world;
        if (player.isCrouching()) {
            if (player.getCooldowns().isOnCooldown(tool.getItem())) {
                return;
            }
            player.getCooldowns().addCooldown(tool.getItem(), 200);
            if (world instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)world;
                int clearRadius = 5;
                for (int dx = -clearRadius; dx <= clearRadius; ++dx) {
                    for (int dy = -clearRadius; dy <= clearRadius; ++dy) {
                        for (int dz = -clearRadius; dz <= clearRadius; ++dz) {
                            BlockPos currentPosInArea = startPos.offset(dx, dy, dz);
                            BlockState stateInArea = serverLevel.getBlockState(currentPosInArea);
                            if (stateInArea.getBlock() != initialBlock || stateInArea.getBlock() == Blocks.BEDROCK) continue;
                            serverLevel.setBlock(currentPosInArea, Blocks.AIR.defaultBlockState(), 3);
                        }
                    }
                }
                level.playSound(null, startPos, SoundEvents.WITHER_BREAK_BLOCK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        } else {
            if (!MattockBlockDestroyedWithToolProcedure.isOreBlock(initialBlock)) {
                return;
            }
            HashSet<BlockPos> brokenBlocks = new HashSet<BlockPos>();
            LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
            toCheck.add(startPos);
            int maxBlocksToVeinmine = 64;
            while (!toCheck.isEmpty() && brokenBlocks.size() < maxBlocksToVeinmine) {
                BlockState currentState;
                BlockPos currentPos = (BlockPos)toCheck.poll();
                if (brokenBlocks.contains(currentPos) || (currentState = level.getBlockState(currentPos)).getBlock() != initialBlock) continue;
                brokenBlocks.add(currentPos);
                for (BlockPos neighbor : List.of(currentPos.north(), currentPos.south(), currentPos.east(), currentPos.west(), currentPos.above(), currentPos.below())) {
                    if (brokenBlocks.contains(neighbor) || level.getBlockState(neighbor).getBlock() != initialBlock) continue;
                    toCheck.add(neighbor);
                }
            }
            if (brokenBlocks.isEmpty()) {
                return;
            }
            if (level instanceof ServerLevel) {
                ServerLevel serverLevelInstance = (ServerLevel)level;
                for (BlockPos posToBreak : brokenBlocks) {
                    BlockState stateToBreak = serverLevelInstance.getBlockState(posToBreak);
                    if (stateToBreak.getBlock() != initialBlock || stateToBreak.isAir() || stateToBreak.getBlock() == Blocks.BEDROCK) continue;
                    LootParams.Builder lootParamsBuilder = new LootParams.Builder(serverLevelInstance).withParameter(LootContextParams.ORIGIN, (Object)posToBreak.getCenter()).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.BLOCK_STATE, (Object)stateToBreak).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player);
                    List drops = stateToBreak.getDrops(lootParamsBuilder);
                    for (ItemStack stack : drops) {
                        if (stack.isEmpty()) continue;
                        Block.popResource((Level)serverLevelInstance, (BlockPos)posToBreak, (ItemStack)stack.copy());
                    }
                    serverLevelInstance.setBlock(posToBreak, Blocks.AIR.defaultBlockState(), 3);
                }
            }
        }
    }

    private static boolean isOreBlock(Block block) {
        return block == Blocks.COAL_ORE || block == Blocks.IRON_ORE || block == Blocks.GOLD_ORE || block == Blocks.DIAMOND_ORE || block == Blocks.EMERALD_ORE || block == Blocks.LAPIS_ORE || block == Blocks.REDSTONE_ORE || block == Blocks.NETHER_GOLD_ORE || block == Blocks.NETHER_QUARTZ_ORE || block == Blocks.COPPER_ORE || block == Blocks.DEEPSLATE_COAL_ORE || block == Blocks.DEEPSLATE_IRON_ORE || block == Blocks.DEEPSLATE_GOLD_ORE || block == Blocks.DEEPSLATE_DIAMOND_ORE || block == Blocks.DEEPSLATE_EMERALD_ORE || block == Blocks.DEEPSLATE_LAPIS_ORE || block == Blocks.DEEPSLATE_REDSTONE_ORE || block == Blocks.DEEPSLATE_COPPER_ORE;
    }
}

