/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.voidsmith.procedures;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;

public class SpadedBlockDestroyedWithToolProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        Player player;
        block11: {
            block10: {
                if (!(entity instanceof Player)) break block10;
                player = (Player)entity;
                if (world instanceof ServerLevel) break block11;
            }
            return;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        RandomSource random = serverLevel.random;
        if (!player.isCrouching()) {
            if (random.nextFloat() < 0.05f) {
                SpadedBlockDestroyedWithToolProcedure.dropSingleRandomLootFromBuriedTreasure(serverLevel, new BlockPos((int)x, (int)y, (int)z), itemstack);
            }
            return;
        }
        if (player.getCooldowns().isOnCooldown(itemstack.getItem())) {
            return;
        }
        player.getCooldowns().addCooldown(itemstack.getItem(), 600);
        int radius = 8;
        int minY = (int)y - 1;
        int maxY = serverLevel.getMaxBuildHeight();
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dz = -radius; dz <= radius; ++dz) {
                for (int dy = minY; dy < maxY; ++dy) {
                    BlockPos targetPos = new BlockPos((int)x + dx, dy, (int)z + dz);
                    BlockState blockState = serverLevel.getBlockState(targetPos);
                    Block block = blockState.getBlock();
                    if (blockState.isAir() || block == Blocks.BEDROCK || !itemstack.isCorrectToolForDrops(blockState)) continue;
                    List drops = blockState.getDrops(new LootParams.Builder(serverLevel).withParameter(LootContextParams.TOOL, (Object)itemstack).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)targetPos)).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player));
                    serverLevel.setBlock(targetPos, Blocks.AIR.defaultBlockState(), 3);
                    for (ItemStack drop : drops) {
                        Block.popResource((Level)serverLevel, (BlockPos)targetPos, (ItemStack)drop);
                    }
                    if (!(random.nextFloat() < 0.05f)) continue;
                    SpadedBlockDestroyedWithToolProcedure.dropSingleRandomLootFromBuriedTreasure(serverLevel, targetPos, itemstack);
                }
            }
        }
    }

    private static void dropSingleRandomLootFromBuriedTreasure(ServerLevel world, BlockPos pos, ItemStack tool) {
        LootParams.Builder lootParamsBuilder;
        LootParams lootParams;
        MinecraftServer server = world.getServer();
        if (server == null) {
            return;
        }
        LootTable lootTable = server.reloadableRegistries().getLootTable(BuiltInLootTables.BURIED_TREASURE);
        ObjectArrayList loot = lootTable.getRandomItems(lootParams = (lootParamsBuilder = new LootParams.Builder(world).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)tool)).create(LootContextParamSets.CHEST));
        if (!loot.isEmpty()) {
            ItemStack randomItem = (ItemStack)loot.get(world.random.nextInt(loot.size()));
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)randomItem);
        }
    }
}

