/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.pieking1215.invmove.InvMoveConfig;
import me.pieking1215.invmove.InvMoveNoOp;
import me.pieking1215.invmove.module.CVComponent;
import me.pieking1215.invmove.module.Module;
import me.pieking1215.invmove.module.VanillaModule;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InvMove {
    public static final String MOD_ID = "invmove";
    public static final Logger LOGGER = LogManager.getLogger();
    private static InvMove instance;
    private static final KeyMapping TOGGLE_MOVEMENT_KEY;
    private static final List<Module> addonModules;
    private final HashMap<Class<?>, Optional<String>> modidFromClassCache = new HashMap();
    protected boolean wasSneaking = false;
    protected boolean wasMovementDisallowed = false;
    protected boolean wasToggleMovementPressed = false;
    protected Map<ToggleKeyMapping, Boolean> wasToggleKeyDown = new HashMap<ToggleKeyMapping, Boolean>();
    protected boolean forceRawKeyDown = false;
    public final List<Module> modules = new ArrayList<Module>();

    public static InvMove instance() {
        if (instance == null) {
            instance = new InvMoveNoOp();
        }
        return instance;
    }

    public static void setInstance(InvMove newInstance) {
        instance = newInstance;
    }

    public static void registerModule(Module module) {
        LOGGER.info("Registered Module: {}", (Object)module);
        (instance != null ? InvMove.instance.modules : addonModules).add(module);
    }

    protected abstract Optional<String> modidFromClassInternal(Class<?> var1);

    public Optional<String> modidFromClass(Class<?> c) {
        return this.modidFromClassCache.computeIfAbsent(c, this::modidFromClassInternal);
    }

    public abstract String modNameFromModid(String var1);

    public abstract boolean hasMod(String var1);

    public abstract File configDir();

    protected abstract void registerKeybind(KeyMapping var1);

    public MutableComponent translatableComponent(String key) {
        return Component.m_237115_((String)key);
    }

    public MutableComponent literalComponent(String text) {
        return Component.m_237113_((String)text);
    }

    public MutableComponent fromCV(CVComponent c) {
        if (c.translate) {
            return this.translatableComponent(c.text);
        }
        return this.literalComponent(c.text);
    }

    public boolean optionToggleCrouch() {
        return (Boolean)Minecraft.m_91087_().f_91066_.m_231831_().m_231551_();
    }

    public void setOptionToggleCrouch(boolean toggleCrouch) {
        Minecraft.m_91087_().f_91066_.m_231831_().m_231514_((Object)toggleCrouch);
    }

    protected void drawShadow(Font font, PoseStack poseStack, String string, float x, float y, int col) {
        BufferBuilder builder = Tesselator.m_85913_().m_85915_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)builder);
        font.m_271703_(string, x, y, col, true, poseStack.m_85850_().m_252922_(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.m_109911_();
    }

    public ResourceLocation parseResource(String path) {
        return new ResourceLocation(path);
    }

    public InvMove() {
        this.modules.addAll(addonModules);
        addonModules.clear();
        this.modules.add(0, this.getVanillaModule());
        this.registerKeybind(TOGGLE_MOVEMENT_KEY);
    }

    public Module getVanillaModule() {
        return new VanillaModule();
    }

    public void finishInit() {
        InvMoveConfig.load();
    }

    private boolean handleToggleMovementKey(Screen screen, boolean couldMove) {
        if (TOGGLE_MOVEMENT_KEY.m_90862_()) {
            return couldMove;
        }
        TOGGLE_MOVEMENT_KEY.m_7249_(InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)InvMove.TOGGLE_MOVEMENT_KEY.f_90816_.m_84873_()));
        boolean before = this.wasToggleMovementPressed;
        this.wasToggleMovementPressed = InvMove.TOGGLE_MOVEMENT_KEY.f_90817_;
        if (InvMove.TOGGLE_MOVEMENT_KEY.f_90817_ && !before) {
            if (screen == null) {
                InvMoveConfig.MOVEMENT.ENABLED.set((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get() == false);
                return couldMove;
            }
            if (couldMove && ((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
            if (!couldMove && !((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(true);
                if (this.allowMovementInScreen(screen)) {
                    return true;
                }
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
        }
        return couldMove;
    }

    private boolean shouldSneak(InvMoveConfig.Movement.SneakMode sneakMode, boolean shiftIsDown) {
        switch (sneakMode) {
            case Off: {
                return false;
            }
            case MaintainWhilePressed: {
                if (!shiftIsDown) {
                    this.wasSneaking = false;
                }
            }
            case Maintain: {
                return this.wasSneaking;
            }
            case Pressed: {
                return shiftIsDown;
            }
        }
        return false;
    }

    public void onInputUpdate(Input input, boolean sneaking, float sneakSpeed) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (input.getClass() != KeyboardInput.class || input != Minecraft.m_91087_().f_91074_.f_108618_) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (Minecraft.m_91087_().f_91080_ == null) {
            this.wasSneaking = input.f_108573_;
        }
        boolean canMove = this.allowMovementInScreen(Minecraft.m_91087_().f_91080_);
        if (canMove = this.handleToggleMovementKey(Minecraft.m_91087_().f_91080_, canMove)) {
            this.wasMovementDisallowed = false;
            this.tickKeybinds();
            boolean shiftIsDown = Minecraft.m_91087_().f_91066_.f_92090_.f_90817_;
            Minecraft.m_91087_().f_91066_.f_92094_.m_7249_(false);
            if (!this.optionToggleCrouch()) {
                if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20159_()) {
                    Minecraft.m_91087_().f_91066_.f_92090_.m_7249_((Boolean)InvMoveConfig.MOVEMENT.DISMOUNT.get() != false && Minecraft.m_91087_().f_91066_.f_92090_.f_90817_);
                } else {
                    boolean isCreativeFlying = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_150110_().f_35935_;
                    InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_FLYING.get()) : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get());
                    boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                    Minecraft.m_91087_().f_91066_.f_92090_.m_7249_(sneakKey);
                }
            }
            this.inputTickRaw(input, sneaking, sneakSpeed);
        } else if (Minecraft.m_91087_().f_91080_ != null) {
            if (!this.wasMovementDisallowed) {
                for (KeyMapping key : KeyMapping.f_90809_.values()) {
                    if (!this.allowKey(key)) continue;
                    key.m_90866_();
                }
            }
            this.wasMovementDisallowed = true;
            if (!(!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue() || this.optionToggleCrouch() || Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_20159_())) {
                this.tickKeybind(Minecraft.m_91087_().f_91066_.f_92090_);
                boolean shiftIsDown = Minecraft.m_91087_().f_91066_.f_92090_.f_90817_;
                boolean isCreativeFlying = Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_150110_().f_35935_;
                InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? InvMoveConfig.Movement.SneakMode.Off : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_DISALLOWED.get());
                boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                Minecraft.m_91087_().f_91066_.f_92090_.m_7249_(sneakKey);
                input.f_108573_ = sneakKey;
            }
        } else {
            this.wasMovementDisallowed = false;
        }
    }

    private void tickKeybinds() {
        for (KeyMapping k : KeyMapping.f_90809_.values()) {
            if (!this.allowKey(k)) continue;
            this.tickKeybind(k);
        }
    }

    private void tickKeybind(KeyMapping k) {
        if (k.f_90816_.m_84868_() == InputConstants.Type.KEYSYM && k.f_90816_.m_84873_() != InputConstants.f_84822_.m_84873_()) {
            boolean raw = InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)k.f_90816_.m_84873_());
            if (k instanceof ToggleKeyMapping && ((ToggleKeyMapping)k).f_92527_.getAsBoolean()) {
                if (this.wasToggleKeyDown.containsKey(k) && !this.wasToggleKeyDown.get(k).booleanValue() && raw) {
                    if (k == Minecraft.m_91087_().f_91066_.f_92090_) {
                        if (InvMoveConfig.MOVEMENT.SNEAK.get() == InvMoveConfig.Movement.SneakMode.Pressed) {
                            k.m_7249_(true);
                        }
                    } else {
                        k.m_7249_(true);
                    }
                }
                this.wasToggleKeyDown.put((ToggleKeyMapping)k, raw);
            } else {
                k.m_7249_(raw);
            }
        }
    }

    public boolean allowKey(KeyMapping key) {
        String k = key.m_90860_();
        if (InvMoveConfig.MOVEMENT.allowedKeys.containsKey(k)) {
            return InvMoveConfig.MOVEMENT.allowedKeys.get(k);
        }
        boolean allow = this.allowKeyDefault(key);
        InvMoveConfig.MOVEMENT.allowedKeys.put(k, allow);
        return allow;
    }

    public boolean allowKeyDefault(KeyMapping key) {
        for (Module module : this.modules) {
            Optional<Boolean> def = module.allowKeyDefault(key);
            if (!def.isPresent()) continue;
            return def.get();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean allowMovementInScreen(Screen screen) {
        void var2_8;
        if (screen == null) {
            return false;
        }
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (Minecraft.m_91087_().m_91104_()) {
            return false;
        }
        Optional optional = Optional.empty();
        block7: for (Module mod : this.modules) {
            Module.Movement res = mod.shouldAllowMovement(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_ENABLE: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block7;
                }
                case FORCE_DISABLE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block7;
                }
                case SUGGEST_ENABLE: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_DISABLE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (var2_8.isPresent()) {
            return (Boolean)var2_8.get();
        }
        Class<?> cl = screen.getClass();
        String modid = this.modidFromClass(cl).orElse("?unknown");
        InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.putIfAbsent(modid, new HashMap());
        HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
        if (!hm.containsKey(cl)) {
            hm.put(cl, (Boolean)InvMoveConfig.MOVEMENT.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
        }
        return hm.get(cl);
    }

    public static Field[] getDeclaredFieldsSuper(Class<?> aClass) {
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            fs.addAll(Arrays.asList(aClass.getDeclaredFields()));
        } while ((aClass = aClass.getSuperclass()) != null);
        return fs.toArray(new Field[0]);
    }

    public void inputTickRaw(Input input, boolean sneaking, float sneakSpeed) {
        this.forceRawKeyDown = true;
        input.m_214106_(sneaking, sneakSpeed);
        this.forceRawKeyDown = false;
    }

    public boolean shouldForceRawKeyDown() {
        return this.forceRawKeyDown;
    }

    public <T> T withRawKeyDown(Supplier<T> r) {
        boolean was = this.forceRawKeyDown;
        this.forceRawKeyDown = true;
        T v = r.get();
        this.forceRawKeyDown = was;
        return v;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean shouldDisableScreenBackground(Screen screen) {
        void var2_8;
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.BACKGROUND.BACKGROUND_HIDE.get()).booleanValue()) {
            return false;
        }
        if (screen == null) {
            return false;
        }
        if (screen.m_7043_()) {
            switch ((InvMoveConfig.Background.PauseScreenMode)((Object)InvMoveConfig.BACKGROUND.HIDE_ON_PAUSE.get())) {
                case Show: {
                    return false;
                }
                case AllowHide: {
                    break;
                }
                case ShowSP: {
                    if (!Minecraft.m_91087_().m_91091_()) break;
                    if (Minecraft.m_91087_().m_91092_() == null) return false;
                    if (Minecraft.m_91087_().m_91092_().m_6992_()) break;
                    return false;
                }
            }
        }
        Optional optional = Optional.empty();
        block12: for (Module mod : this.modules) {
            Module.Background res = mod.shouldHideBackground(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_SHOW: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block12;
                }
                case FORCE_HIDE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block12;
                }
                case SUGGEST_SHOW: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_HIDE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (!var2_8.isPresent()) {
            Class<?> cl = screen.getClass();
            String modid = this.modidFromClass(cl).orElse("?unknown");
            InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.putIfAbsent(modid, new HashMap());
            HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            if (hm.containsKey(cl)) return hm.get(cl);
            hm.put(cl, (Boolean)InvMoveConfig.BACKGROUND.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
            return hm.get(cl);
        }
        if ((Boolean)var2_8.get() != false) return false;
        return true;
    }

    public void drawDebugOverlay() {
        if (((Boolean)InvMoveConfig.GENERAL.DEBUG_DISPLAY.get()).booleanValue()) {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen == null) {
                return;
            }
            int i = 0;
            Class<?> cl = screen.getClass();
            while (cl.getSuperclass() != null) {
                Optional<String> modid;
                Object className = cl.getName();
                if (((String)className).startsWith("net.minecraft.")) {
                    className = ((String)className).substring("net.minecraft.".length());
                }
                if ((modid = this.modidFromClass(cl)).isPresent()) {
                    className = "[" + modid.get() + "] " + (String)className;
                }
                if (this.shouldDisableScreenBackground(screen)) {
                    className = "B" + (String)className;
                }
                if (this.allowMovementInScreen(screen)) {
                    className = "M" + (String)className;
                }
                this.drawShadow(Minecraft.m_91087_().f_91062_, new PoseStack(), (String)className, 4.0f, 4 + 10 * i, -1);
                ++i;
                cl = cl.getSuperclass();
            }
        }
    }

    static {
        TOGGLE_MOVEMENT_KEY = new KeyMapping("keybind.invmove.toggleMove", InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), "key.category.invmove.main");
        addonModules = new ArrayList<Module>();
    }
}

