/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.pieking1215.invmove.InvMoveConfig;
import me.pieking1215.invmove.InvMoveNoOp;
import me.pieking1215.invmove.module.CVComponent;
import me.pieking1215.invmove.module.Module;
import me.pieking1215.invmove.module.VanillaModule;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ToggleKeyMapping;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.ClientInput;
import net.minecraft.client.player.KeyboardInput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Input;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InvMove {
    public static final String MOD_ID = "invmove";
    public static final Logger LOGGER = LogManager.getLogger();
    private static InvMove instance;
    private static final KeyMapping TOGGLE_MOVEMENT_KEY;
    private static final List<Module> addonModules;
    private final HashMap<Class<?>, Optional<String>> modidFromClassCache = new HashMap();
    protected boolean wasSneaking = false;
    protected boolean wasMovementDisallowed = false;
    protected boolean wasToggleMovementPressed = false;
    protected Map<ToggleKeyMapping, Boolean> wasToggleKeyDown = new HashMap<ToggleKeyMapping, Boolean>();
    protected boolean forceRawKeyDown = false;
    public final List<Module> modules = new ArrayList<Module>();

    public static InvMove instance() {
        if (instance == null) {
            instance = new InvMoveNoOp();
        }
        return instance;
    }

    public static void setInstance(InvMove newInstance) {
        instance = newInstance;
    }

    public static void registerModule(Module module) {
        LOGGER.info("Registered Module: {}", (Object)module);
        (instance != null ? InvMove.instance.modules : addonModules).add(module);
    }

    protected abstract Optional<String> modidFromClassInternal(Class<?> var1);

    public Optional<String> modidFromClass(Class<?> c) {
        return this.modidFromClassCache.computeIfAbsent(c, this::modidFromClassInternal);
    }

    public abstract String modNameFromModid(String var1);

    public abstract boolean hasMod(String var1);

    public abstract File configDir();

    protected abstract void registerKeybind(KeyMapping var1);

    public MutableComponent translatableComponent(String key) {
        return Component.translatable((String)key);
    }

    public MutableComponent literalComponent(String text) {
        return Component.literal((String)text);
    }

    public MutableComponent fromCV(CVComponent c) {
        if (c.translate) {
            return this.translatableComponent(c.text);
        }
        return this.literalComponent(c.text);
    }

    public boolean optionToggleCrouch() {
        return (Boolean)Minecraft.getInstance().options.toggleCrouch().get();
    }

    public void setOptionToggleCrouch(boolean toggleCrouch) {
        Minecraft.getInstance().options.toggleCrouch().set((Object)toggleCrouch);
    }

    protected void drawShadow(Font font, PoseStack poseStack, String string, float x, float y, int col) {
        ByteBufferBuilder builder = new ByteBufferBuilder(786432);
        MultiBufferSource.BufferSource buffer = MultiBufferSource.immediate((ByteBufferBuilder)builder);
        font.drawInBatch(string, x, y, col, true, poseStack.last().pose(), (MultiBufferSource)buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        buffer.endBatch();
    }

    public ResourceLocation parseResource(String path) {
        return ResourceLocation.parse((String)path);
    }

    public InvMove() {
        this.modules.addAll(addonModules);
        addonModules.clear();
        this.modules.add(0, this.getVanillaModule());
        this.registerKeybind(TOGGLE_MOVEMENT_KEY);
    }

    public Module getVanillaModule() {
        return new VanillaModule();
    }

    public void finishInit() {
        InvMoveConfig.load();
    }

    private boolean handleToggleMovementKey(Screen screen, boolean couldMove) {
        if (TOGGLE_MOVEMENT_KEY.isUnbound()) {
            return couldMove;
        }
        TOGGLE_MOVEMENT_KEY.setDown(InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)InvMove.TOGGLE_MOVEMENT_KEY.key.getValue()));
        boolean before = this.wasToggleMovementPressed;
        this.wasToggleMovementPressed = InvMove.TOGGLE_MOVEMENT_KEY.isDown;
        if (InvMove.TOGGLE_MOVEMENT_KEY.isDown && !before) {
            if (screen == null) {
                InvMoveConfig.MOVEMENT.ENABLED.set((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get() == false);
                return couldMove;
            }
            if (couldMove && ((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
            if (!couldMove && !((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(true);
                if (this.allowMovementInScreen(screen)) {
                    return true;
                }
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
        }
        return couldMove;
    }

    private boolean shouldSneak(InvMoveConfig.Movement.SneakMode sneakMode, boolean shiftIsDown) {
        switch (sneakMode) {
            case Off: {
                return false;
            }
            case MaintainWhilePressed: {
                if (!shiftIsDown) {
                    this.wasSneaking = false;
                }
            }
            case Maintain: {
                return this.wasSneaking;
            }
            case Pressed: {
                return shiftIsDown;
            }
        }
        return false;
    }

    public void onInputUpdate(ClientInput input) {
        if (Minecraft.getInstance().player == null) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (input.getClass() != KeyboardInput.class || input != Minecraft.getInstance().player.input) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (Minecraft.getInstance().screen == null) {
            this.wasSneaking = input.keyPresses.shift();
        }
        boolean canMove = this.allowMovementInScreen(Minecraft.getInstance().screen);
        if (canMove = this.handleToggleMovementKey(Minecraft.getInstance().screen, canMove)) {
            this.wasMovementDisallowed = false;
            this.tickKeybinds();
            boolean shiftIsDown = Minecraft.getInstance().options.keyShift.isDown;
            Minecraft.getInstance().options.keyDrop.setDown(false);
            if (!this.optionToggleCrouch()) {
                if (Minecraft.getInstance().player != null && Minecraft.getInstance().player.isPassenger()) {
                    Minecraft.getInstance().options.keyShift.setDown((Boolean)InvMoveConfig.MOVEMENT.DISMOUNT.get() != false && Minecraft.getInstance().options.keyShift.isDown);
                } else {
                    boolean isCreativeFlying = Minecraft.getInstance().player != null && Minecraft.getInstance().player.getAbilities().flying;
                    InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_FLYING.get()) : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get());
                    boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                    Minecraft.getInstance().options.keyShift.setDown(sneakKey);
                }
            }
            this.inputTickRaw(input);
        } else if (Minecraft.getInstance().screen != null) {
            if (!this.wasMovementDisallowed) {
                for (KeyMapping key : KeyMapping.ALL.values()) {
                    if (!this.allowKey(key)) continue;
                    key.release();
                }
            }
            this.wasMovementDisallowed = true;
            if (!(!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue() || this.optionToggleCrouch() || Minecraft.getInstance().player != null && Minecraft.getInstance().player.isPassenger())) {
                this.tickKeybind(Minecraft.getInstance().options.keyShift);
                boolean shiftIsDown = Minecraft.getInstance().options.keyShift.isDown;
                boolean isCreativeFlying = Minecraft.getInstance().player != null && Minecraft.getInstance().player.getAbilities().flying;
                InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? InvMoveConfig.Movement.SneakMode.Off : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_DISALLOWED.get());
                boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                Minecraft.getInstance().options.keyShift.setDown(sneakKey);
                input.keyPresses = new Input(input.keyPresses.forward(), input.keyPresses.backward(), input.keyPresses.left(), input.keyPresses.right(), input.keyPresses.jump(), sneakKey, input.keyPresses.sprint());
            }
        } else {
            this.wasMovementDisallowed = false;
        }
    }

    private void tickKeybinds() {
        for (KeyMapping k : KeyMapping.ALL.values()) {
            if (!this.allowKey(k)) continue;
            this.tickKeybind(k);
        }
    }

    private void tickKeybind(KeyMapping k) {
        if (k.key.getType() == InputConstants.Type.KEYSYM && k.key.getValue() != InputConstants.UNKNOWN.getValue()) {
            boolean raw = InputConstants.isKeyDown((long)Minecraft.getInstance().getWindow().getWindow(), (int)k.key.getValue());
            if (k instanceof ToggleKeyMapping && ((ToggleKeyMapping)k).needsToggle.getAsBoolean()) {
                if (this.wasToggleKeyDown.containsKey(k) && !this.wasToggleKeyDown.get(k).booleanValue() && raw) {
                    if (k == Minecraft.getInstance().options.keyShift) {
                        if (InvMoveConfig.MOVEMENT.SNEAK.get() == InvMoveConfig.Movement.SneakMode.Pressed) {
                            k.setDown(true);
                        }
                    } else {
                        k.setDown(true);
                    }
                }
                this.wasToggleKeyDown.put((ToggleKeyMapping)k, raw);
            } else {
                k.setDown(raw);
            }
        }
    }

    public boolean allowKey(KeyMapping key) {
        String k = key.getName();
        if (InvMoveConfig.MOVEMENT.allowedKeys.containsKey(k)) {
            return InvMoveConfig.MOVEMENT.allowedKeys.get(k);
        }
        boolean allow = this.allowKeyDefault(key);
        InvMoveConfig.MOVEMENT.allowedKeys.put(k, allow);
        return allow;
    }

    public boolean allowKeyDefault(KeyMapping key) {
        for (Module module : this.modules) {
            Optional<Boolean> def = module.allowKeyDefault(key);
            if (!def.isPresent()) continue;
            return def.get();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean allowMovementInScreen(Screen screen) {
        void var2_8;
        if (screen == null) {
            return false;
        }
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (Minecraft.getInstance().isPaused()) {
            return false;
        }
        Optional optional = Optional.empty();
        block7: for (Module mod : this.modules) {
            Module.Movement res = mod.shouldAllowMovement(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_ENABLE: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block7;
                }
                case FORCE_DISABLE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block7;
                }
                case SUGGEST_ENABLE: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_DISABLE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (var2_8.isPresent()) {
            return (Boolean)var2_8.get();
        }
        Class<?> cl = screen.getClass();
        String modid = this.modidFromClass(cl).orElse("?unknown");
        InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.putIfAbsent(modid, new HashMap());
        HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
        if (!hm.containsKey(cl)) {
            hm.put(cl, (Boolean)InvMoveConfig.MOVEMENT.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
        }
        return hm.get(cl);
    }

    public static Field[] getDeclaredFieldsSuper(Class<?> aClass) {
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            fs.addAll(Arrays.asList(aClass.getDeclaredFields()));
        } while ((aClass = aClass.getSuperclass()) != null);
        return fs.toArray(new Field[0]);
    }

    public void inputTickRaw(ClientInput input) {
        this.forceRawKeyDown = true;
        input.tick();
        this.forceRawKeyDown = false;
    }

    public boolean shouldForceRawKeyDown() {
        return this.forceRawKeyDown;
    }

    public <T> T withRawKeyDown(Supplier<T> r) {
        boolean was = this.forceRawKeyDown;
        this.forceRawKeyDown = true;
        T v = r.get();
        this.forceRawKeyDown = was;
        return v;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean shouldDisableScreenBackground(Screen screen) {
        void var2_8;
        if (Minecraft.getInstance().player == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.BACKGROUND.BACKGROUND_HIDE.get()).booleanValue()) {
            return false;
        }
        if (screen == null) {
            return false;
        }
        if (screen.isPauseScreen()) {
            switch ((InvMoveConfig.Background.PauseScreenMode)((Object)InvMoveConfig.BACKGROUND.HIDE_ON_PAUSE.get())) {
                case Show: {
                    return false;
                }
                case AllowHide: {
                    break;
                }
                case ShowSP: {
                    if (!Minecraft.getInstance().hasSingleplayerServer()) break;
                    if (Minecraft.getInstance().getSingleplayerServer() == null) return false;
                    if (Minecraft.getInstance().getSingleplayerServer().isPublished()) break;
                    return false;
                }
            }
        }
        Optional optional = Optional.empty();
        block12: for (Module mod : this.modules) {
            Module.Background res = mod.shouldHideBackground(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_SHOW: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block12;
                }
                case FORCE_HIDE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block12;
                }
                case SUGGEST_SHOW: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_HIDE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (!var2_8.isPresent()) {
            Class<?> cl = screen.getClass();
            String modid = this.modidFromClass(cl).orElse("?unknown");
            InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.putIfAbsent(modid, new HashMap());
            HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            if (hm.containsKey(cl)) return hm.get(cl);
            hm.put(cl, (Boolean)InvMoveConfig.BACKGROUND.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
            return hm.get(cl);
        }
        if ((Boolean)var2_8.get() != false) return false;
        return true;
    }

    public void drawDebugOverlay() {
        if (((Boolean)InvMoveConfig.GENERAL.DEBUG_DISPLAY.get()).booleanValue()) {
            Screen screen = Minecraft.getInstance().screen;
            if (screen == null) {
                return;
            }
            int i = 0;
            Class<?> cl = screen.getClass();
            while (cl.getSuperclass() != null) {
                Optional<String> modid;
                Object className = cl.getName();
                if (((String)className).startsWith("net.minecraft.")) {
                    className = ((String)className).substring("net.minecraft.".length());
                }
                if ((modid = this.modidFromClass(cl)).isPresent()) {
                    className = "[" + modid.get() + "] " + (String)className;
                }
                if (this.shouldDisableScreenBackground(screen)) {
                    className = "B" + (String)className;
                }
                if (this.allowMovementInScreen(screen)) {
                    className = "M" + (String)className;
                }
                this.drawShadow(Minecraft.getInstance().font, new PoseStack(), (String)className, 4.0f, 4 + 10 * i, -1);
                ++i;
                cl = cl.getSuperclass();
            }
        }
    }

    static {
        TOGGLE_MOVEMENT_KEY = new KeyMapping("keybind.invmove.toggleMove", InputConstants.Type.KEYSYM, InputConstants.UNKNOWN.getValue(), "key.category.invmove.main");
        addonModules = new ArrayList<Module>();
    }
}

