/*
 * Decompiled with CFR 0.152.
 */
package me.pieking1215.invmove;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import me.pieking1215.invmove.InvMoveConfig;
import me.pieking1215.invmove.InvMoveNoOp;
import me.pieking1215.invmove.module.CVComponent;
import me.pieking1215.invmove.module.Module;
import me.pieking1215.invmove.module.VanillaModule;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.settings.ToggleableKeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.MovementInput;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InvMove {
    public static final String MOD_ID = "invmove";
    public static final Logger LOGGER = LogManager.getLogger();
    private static InvMove instance;
    private static final KeyBinding TOGGLE_MOVEMENT_KEY;
    private static final List<Module> addonModules;
    private final HashMap<Class<?>, Optional<String>> modidFromClassCache = new HashMap();
    protected boolean wasSneaking = false;
    protected boolean wasMovementDisallowed = false;
    protected boolean wasToggleMovementPressed = false;
    protected Map<ToggleableKeyBinding, Boolean> wasToggleKeyDown = new HashMap<ToggleableKeyBinding, Boolean>();
    protected boolean forceRawKeyDown = false;
    public final List<Module> modules = new ArrayList<Module>();

    public static InvMove instance() {
        if (instance == null) {
            instance = new InvMoveNoOp();
        }
        return instance;
    }

    public static void setInstance(InvMove newInstance) {
        instance = newInstance;
    }

    public static void registerModule(Module module) {
        LOGGER.info("Registered Module: {}", (Object)module);
        (instance != null ? InvMove.instance.modules : addonModules).add(module);
    }

    protected abstract Optional<String> modidFromClassInternal(Class<?> var1);

    public Optional<String> modidFromClass(Class<?> c) {
        return this.modidFromClassCache.computeIfAbsent(c, this::modidFromClassInternal);
    }

    public abstract String modNameFromModid(String var1);

    public abstract boolean hasMod(String var1);

    public abstract File configDir();

    protected abstract void registerKeybind(KeyBinding var1);

    public IFormattableTextComponent translatableComponent(String key) {
        return new TranslationTextComponent(key);
    }

    public IFormattableTextComponent literalComponent(String text) {
        return new StringTextComponent(text);
    }

    public IFormattableTextComponent fromCV(CVComponent c) {
        if (c.translate) {
            return this.translatableComponent(c.text);
        }
        return this.literalComponent(c.text);
    }

    public boolean optionToggleCrouch() {
        return Minecraft.func_71410_x().field_71474_y.field_228044_Y_;
    }

    public void setOptionToggleCrouch(boolean toggleCrouch) {
        Minecraft.func_71410_x().field_71474_y.field_228044_Y_ = toggleCrouch;
    }

    protected void drawShadow(FontRenderer font, MatrixStack poseStack, String string, float x, float y, int col) {
        font.func_238421_b_(poseStack, string, x, y, col);
    }

    public ResourceLocation parseResource(String path) {
        return new ResourceLocation(path);
    }

    public InvMove() {
        this.modules.addAll(addonModules);
        addonModules.clear();
        this.modules.add(0, this.getVanillaModule());
        this.registerKeybind(TOGGLE_MOVEMENT_KEY);
    }

    public Module getVanillaModule() {
        return new VanillaModule();
    }

    public void finishInit() {
        InvMoveConfig.load();
    }

    private boolean handleToggleMovementKey(Screen screen, boolean couldMove) {
        if (TOGGLE_MOVEMENT_KEY.func_197986_j()) {
            return couldMove;
        }
        TOGGLE_MOVEMENT_KEY.func_225593_a_(InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)InvMove.TOGGLE_MOVEMENT_KEY.field_74512_d.func_197937_c()));
        boolean before = this.wasToggleMovementPressed;
        this.wasToggleMovementPressed = InvMove.TOGGLE_MOVEMENT_KEY.field_74513_e;
        if (InvMove.TOGGLE_MOVEMENT_KEY.field_74513_e && !before) {
            if (screen == null) {
                InvMoveConfig.MOVEMENT.ENABLED.set((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get() == false);
                return couldMove;
            }
            if (couldMove && ((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
            if (!couldMove && !((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
                InvMoveConfig.MOVEMENT.ENABLED.set(true);
                if (this.allowMovementInScreen(screen)) {
                    return true;
                }
                InvMoveConfig.MOVEMENT.ENABLED.set(false);
                return false;
            }
        }
        return couldMove;
    }

    private boolean shouldSneak(InvMoveConfig.Movement.SneakMode sneakMode, boolean shiftIsDown) {
        switch (sneakMode) {
            case Off: {
                return false;
            }
            case MaintainWhilePressed: {
                if (!shiftIsDown) {
                    this.wasSneaking = false;
                }
            }
            case Maintain: {
                return this.wasSneaking;
            }
            case Pressed: {
                return shiftIsDown;
            }
        }
        return false;
    }

    public void onInputUpdate(MovementInput input, boolean sneaking) {
        if (Minecraft.func_71410_x().field_71439_g == null) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (input.getClass() != MovementInputFromOptions.class || input != Minecraft.func_71410_x().field_71439_g.field_71158_b) {
            this.wasMovementDisallowed = false;
            return;
        }
        if (Minecraft.func_71410_x().field_71462_r == null) {
            this.wasSneaking = input.field_228350_h_;
        }
        boolean canMove = this.allowMovementInScreen(Minecraft.func_71410_x().field_71462_r);
        if (canMove = this.handleToggleMovementKey(Minecraft.func_71410_x().field_71462_r, canMove)) {
            this.wasMovementDisallowed = false;
            this.tickKeybinds();
            boolean shiftIsDown = Minecraft.func_71410_x().field_71474_y.field_228046_af_.field_74513_e;
            Minecraft.func_71410_x().field_71474_y.field_74316_C.func_225593_a_(false);
            if (!this.optionToggleCrouch()) {
                if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184218_aH()) {
                    Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_225593_a_((Boolean)InvMoveConfig.MOVEMENT.DISMOUNT.get() != false && Minecraft.func_71410_x().field_71474_y.field_228046_af_.field_74513_e);
                } else {
                    boolean isCreativeFlying = Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75100_b;
                    InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_FLYING.get()) : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK.get());
                    boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                    Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_225593_a_(sneakKey);
                }
            }
            this.inputTickRaw(input, sneaking);
        } else if (Minecraft.func_71410_x().field_71462_r != null) {
            if (!this.wasMovementDisallowed) {
                for (KeyBinding key : KeyBinding.field_74516_a.values()) {
                    if (!this.allowKey(key)) continue;
                    key.func_74505_d();
                }
            }
            this.wasMovementDisallowed = true;
            if (!(!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue() || this.optionToggleCrouch() || Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.func_184218_aH())) {
                this.tickKeybind(Minecraft.func_71410_x().field_71474_y.field_228046_af_);
                boolean shiftIsDown = Minecraft.func_71410_x().field_71474_y.field_228046_af_.field_74513_e;
                boolean isCreativeFlying = Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75100_b;
                InvMoveConfig.Movement.SneakMode mode = isCreativeFlying ? InvMoveConfig.Movement.SneakMode.Off : (InvMoveConfig.Movement.SneakMode)((Object)InvMoveConfig.MOVEMENT.SNEAK_DISALLOWED.get());
                boolean sneakKey = this.shouldSneak(mode, shiftIsDown);
                Minecraft.func_71410_x().field_71474_y.field_228046_af_.func_225593_a_(sneakKey);
                input.field_228350_h_ = sneakKey;
            }
        } else {
            this.wasMovementDisallowed = false;
        }
    }

    private void tickKeybinds() {
        for (KeyBinding k : KeyBinding.field_74516_a.values()) {
            if (!this.allowKey(k)) continue;
            this.tickKeybind(k);
        }
    }

    private void tickKeybind(KeyBinding k) {
        if (k.field_74512_d.func_197938_b() == InputMappings.Type.KEYSYM && k.field_74512_d.func_197937_c() != InputMappings.field_197958_a.func_197937_c()) {
            boolean raw = InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)k.field_74512_d.func_197937_c());
            if (k instanceof ToggleableKeyBinding && ((ToggleableKeyBinding)k).field_228053_a_.getAsBoolean()) {
                if (this.wasToggleKeyDown.containsKey(k) && !this.wasToggleKeyDown.get(k).booleanValue() && raw) {
                    if (k == Minecraft.func_71410_x().field_71474_y.field_228046_af_) {
                        if (InvMoveConfig.MOVEMENT.SNEAK.get() == InvMoveConfig.Movement.SneakMode.Pressed) {
                            k.func_225593_a_(true);
                        }
                    } else {
                        k.func_225593_a_(true);
                    }
                }
                this.wasToggleKeyDown.put((ToggleableKeyBinding)k, raw);
            } else {
                k.func_225593_a_(raw);
            }
        }
    }

    public boolean allowKey(KeyBinding key) {
        String k = key.func_151464_g();
        if (InvMoveConfig.MOVEMENT.allowedKeys.containsKey(k)) {
            return InvMoveConfig.MOVEMENT.allowedKeys.get(k);
        }
        boolean allow = this.allowKeyDefault(key);
        InvMoveConfig.MOVEMENT.allowedKeys.put(k, allow);
        return allow;
    }

    public boolean allowKeyDefault(KeyBinding key) {
        for (Module module : this.modules) {
            Optional<Boolean> def = module.allowKeyDefault(key);
            if (!def.isPresent()) continue;
            return def.get();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean allowMovementInScreen(Screen screen) {
        void var2_8;
        if (screen == null) {
            return false;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.MOVEMENT.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            return false;
        }
        Optional optional = Optional.empty();
        block7: for (Module mod : this.modules) {
            Module.Movement res = mod.shouldAllowMovement(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_ENABLE: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block7;
                }
                case FORCE_DISABLE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block7;
                }
                case SUGGEST_ENABLE: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_DISABLE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (var2_8.isPresent()) {
            return (Boolean)var2_8.get();
        }
        Class<?> cl = screen.getClass();
        String modid = this.modidFromClass(cl).orElse("?unknown");
        InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.putIfAbsent(modid, new HashMap());
        HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.MOVEMENT.unrecognizedScreensAllowMovement.get(modid);
        if (!hm.containsKey(cl)) {
            hm.put(cl, (Boolean)InvMoveConfig.MOVEMENT.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
        }
        return hm.get(cl);
    }

    public static Field[] getDeclaredFieldsSuper(Class<?> aClass) {
        ArrayList<Field> fs = new ArrayList<Field>();
        do {
            fs.addAll(Arrays.asList(aClass.getDeclaredFields()));
        } while ((aClass = aClass.getSuperclass()) != null);
        return fs.toArray(new Field[0]);
    }

    public void inputTickRaw(MovementInput input, boolean sneaking) {
        this.forceRawKeyDown = true;
        input.func_225607_a_(sneaking);
        this.forceRawKeyDown = false;
    }

    public boolean shouldForceRawKeyDown() {
        return this.forceRawKeyDown;
    }

    public <T> T withRawKeyDown(Supplier<T> r) {
        boolean was = this.forceRawKeyDown;
        this.forceRawKeyDown = true;
        T v = r.get();
        this.forceRawKeyDown = was;
        return v;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public boolean shouldDisableScreenBackground(Screen screen) {
        void var2_8;
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.GENERAL.ENABLED.get()).booleanValue()) {
            return false;
        }
        if (!((Boolean)InvMoveConfig.BACKGROUND.BACKGROUND_HIDE.get()).booleanValue()) {
            return false;
        }
        if (screen == null) {
            return false;
        }
        if (screen.func_231177_au__()) {
            switch ((InvMoveConfig.Background.PauseScreenMode)((Object)InvMoveConfig.BACKGROUND.HIDE_ON_PAUSE.get())) {
                case Show: {
                    return false;
                }
                case AllowHide: {
                    break;
                }
                case ShowSP: {
                    if (!Minecraft.func_71410_x().func_71356_B()) break;
                    if (Minecraft.func_71410_x().func_71401_C() == null) return false;
                    if (Minecraft.func_71410_x().func_71401_C().func_71344_c()) break;
                    return false;
                }
            }
        }
        Optional optional = Optional.empty();
        block12: for (Module mod : this.modules) {
            Module.Background res = mod.shouldHideBackground(screen);
            switch (res) {
                case PASS: {
                    break;
                }
                case FORCE_SHOW: {
                    Optional<Boolean> optional2 = Optional.of(true);
                    break block12;
                }
                case FORCE_HIDE: {
                    Optional<Boolean> optional3 = Optional.of(false);
                    break block12;
                }
                case SUGGEST_SHOW: {
                    Optional<Boolean> optional4 = Optional.of(true);
                    break;
                }
                case SUGGEST_HIDE: {
                    Optional<Boolean> optional5 = Optional.of(false);
                }
            }
        }
        if (!var2_8.isPresent()) {
            Class<?> cl = screen.getClass();
            String modid = this.modidFromClass(cl).orElse("?unknown");
            InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.putIfAbsent(modid, new HashMap());
            HashMap<Class<? extends Screen>, Boolean> hm = InvMoveConfig.BACKGROUND.unrecognizedScreensHideBG.get(modid);
            if (hm.containsKey(cl)) return hm.get(cl);
            hm.put(cl, (Boolean)InvMoveConfig.BACKGROUND.UNRECOGNIZED_SCREEN_DEFAULT.get());
            InvMoveConfig.save();
            return hm.get(cl);
        }
        if ((Boolean)var2_8.get() != false) return false;
        return true;
    }

    public void drawDebugOverlay() {
        if (((Boolean)InvMoveConfig.GENERAL.DEBUG_DISPLAY.get()).booleanValue()) {
            Screen screen = Minecraft.func_71410_x().field_71462_r;
            if (screen == null) {
                return;
            }
            int i = 0;
            Class<?> cl = screen.getClass();
            while (cl.getSuperclass() != null) {
                Optional<String> modid;
                String className = cl.getName();
                if (className.startsWith("net.minecraft.")) {
                    className = className.substring("net.minecraft.".length());
                }
                if ((modid = this.modidFromClass(cl)).isPresent()) {
                    className = "[" + modid.get() + "] " + className;
                }
                if (this.shouldDisableScreenBackground(screen)) {
                    className = "B" + className;
                }
                if (this.allowMovementInScreen(screen)) {
                    className = "M" + className;
                }
                this.drawShadow(Minecraft.func_71410_x().field_71466_p, new MatrixStack(), className, 4.0f, 4 + 10 * i, -1);
                ++i;
                cl = cl.getSuperclass();
            }
        }
    }

    static {
        TOGGLE_MOVEMENT_KEY = new KeyBinding("keybind.invmove.toggleMove", InputMappings.Type.KEYSYM, InputMappings.field_197958_a.func_197937_c(), "key.category.invmove.main");
        addonModules = new ArrayList<Module>();
    }
}

