/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.client;

import it.hurts.shatterbyte.shatterlib.client.TestWidget;
import it.hurts.shatterbyte.shatterlib.client.animation.Tween;
import it.hurts.shatterbyte.shatterlib.client.animation.easing.EaseType;
import it.hurts.shatterbyte.shatterlib.client.animation.easing.TransitionType;
import it.hurts.shatterbyte.shatterlib.client.particle.GalacticUIParticle;
import it.hurts.shatterbyte.shatterlib.client.particle.UIParticle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.joml.Vector2d;

public class TestScreen
extends Screen {
    private int ticker;
    private boolean down;
    public Vector2d squeeze = new Vector2d(1.0, 1.0);

    public TestScreen() {
        super((Component)Component.empty());
    }

    protected void init() {
        int x = 8;
        int y = 16;
        for (TransitionType transitionType : TransitionType.values()) {
            for (EaseType easeType : EaseType.values()) {
                this.addRenderableWidget((GuiEventListener)new TestWidget(x, y, transitionType, easeType, this));
                if ((y += 30) + 30 <= this.height) continue;
                x += 120;
                y = 16;
            }
        }
    }

    public void tick() {
        super.tick();
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.width / 2.0f, (float)this.height / 2.0f);
        guiGraphics.pose().scale((float)this.squeeze.x, (float)this.squeeze.y);
        guiGraphics.pose().translate((float)(-this.width) / 2.0f, (float)(-this.height) / 2.0f);
        GalacticUIParticle uiParticle = new GalacticUIParticle(20.0f, 2, i, j, UIParticle.Layer.SCREEN, 1.0f);
        uiParticle.setScreen(this);
        uiParticle.instantiate();
        super.render(guiGraphics, i, j, f);
        guiGraphics.drawString(Minecraft.getInstance().font, String.valueOf(this.ticker), this.width - Minecraft.getInstance().font.width(String.valueOf(this.ticker)) - 4, 4, -1, true);
        guiGraphics.drawString(Minecraft.getInstance().font, String.valueOf(f), this.width - Minecraft.getInstance().font.width(String.valueOf(f)) - 4, this.height - 10, 0x33FFFFFF, true);
        guiGraphics.pose().popMatrix();
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        boolean result = super.mouseClicked(event, isDoubleClick);
        if (!result && event.button() == 1) {
            for (GuiEventListener g : this.children()) {
                if (!(g instanceof TestWidget)) continue;
                TestWidget widget = (TestWidget)g;
                widget.onClick(event, isDoubleClick);
            }
        } else if (!result && event.button() == 0) {
            Tween tween = Tween.create().setTransitionType(TransitionType.SINE).setParallel(true);
            tween.tweenProperty((Object)this, "squeeze.y", 0.9, 0.15).setEaseType(EaseType.EASE_OUT);
            tween.tweenProperty((Object)this, "squeeze.x", 0.9, 0.15).setEaseType(EaseType.EASE_IN);
            tween.tweenProperty((Object)this, "squeeze.y", 1, 0.15).setDelay(0.15).setEaseType(EaseType.EASE_OUT);
            tween.tweenProperty((Object)this, "squeeze.x", 1, 0.15).setDelay(0.15).setEaseType(EaseType.EASE_IN);
        }
        return result;
    }

    public boolean isPauseScreen() {
        return true;
    }

    public void onClose() {
        super.onClose();
    }
}

