/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.client;

import it.hurts.shatterbyte.shatterlib.client.animation.Tween;
import it.hurts.shatterbyte.shatterlib.client.animation.easing.EaseType;
import it.hurts.shatterbyte.shatterlib.client.animation.easing.TransitionType;
import it.hurts.shatterbyte.shatterlib.client.particle.GalacticUIParticle;
import it.hurts.shatterbyte.shatterlib.client.particle.UIParticle;
import it.hurts.shatterbyte.shatterlib.util.RenderUtils;
import it.hurts.shatterbyte.shatterlib.util.ShatterColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector2f;

public class TestWidget
extends AbstractWidget {
    protected Screen screen;
    private Vector2f position = new Vector2f();
    private Vector2f scale = new Vector2f(1.0f, 1.0f);
    private ShatterColor color = new ShatterColor(1.0f, 1.0f, 1.0f, 1.0f);
    public TransitionType transitionType;
    public EaseType easeType;
    public Tween tween;
    private Matrix3x2f renderPose = new Matrix3x2f();
    public Tween hoverTween;
    private boolean hasHovered = false;

    public TestWidget(int x, int y, TransitionType transitionType, EaseType easeType, Screen screen) {
        super(x, y, 8, 8, (Component)Component.literal((String)(easeType.name() + "_" + transitionType.name())));
        this.transitionType = transitionType;
        this.easeType = easeType;
        this.screen = screen;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float partialTick) {
        float actualPartialTick = Minecraft.getInstance().getDeltaTracker().getGameTimeDeltaPartialTick(false);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate(this.position.x + (float)this.getX(), this.position.y + (float)this.getY());
        guiGraphics.pose().translate((float)this.width / 2.0f, (float)this.height / 2.0f);
        guiGraphics.pose().scale(this.scale.x, this.scale.y);
        guiGraphics.pose().translate((float)(-this.width) / 2.0f, (float)(-this.height) / 2.0f);
        this.renderPose = new Matrix3x2f((Matrix3x2fc)guiGraphics.pose());
        RenderUtils.renderOutline(guiGraphics, 0, 0, this.getWidth(), this.getHeight(), this.color.getARGB());
        guiGraphics.pose().popMatrix();
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY());
        RenderUtils.renderOutline(guiGraphics, -2, -12, 112, this.getHeight() + 14, 0x50FFFFFF);
        guiGraphics.pose().scale(0.75f, 1.0f);
        guiGraphics.drawString(Minecraft.getInstance().font, this.getMessage(), 0, -10, 0x50FFFFFF, true);
        guiGraphics.pose().popMatrix();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean isHovered() {
        boolean hovered = super.isHovered();
        if (hovered && !this.hasHovered) {
            this.hasHovered = true;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setTransitionType(TransitionType.QUART).setEase(EaseType.EASE_OUT);
            this.hoverTween.tweenProperty((Object)this, "scale", new Vector2f(1.25f, 1.25f), 0.2);
        } else if (!hovered && this.hasHovered) {
            this.hasHovered = false;
            if (this.hoverTween != null) {
                this.hoverTween.kill();
            }
            this.hoverTween = Tween.create().setTransitionType(TransitionType.QUART).setEase(EaseType.EASE_OUT);
            this.hoverTween.tweenProperty((Object)this, "scale", new Vector2f(1.0f, 1.0f), 0.2);
        }
        return hovered;
    }

    public void onClick(MouseButtonEvent event, boolean isDoubleClick) {
        if (this.tween != null) {
            this.tween.kill();
        }
        Runnable spawnParticle = () -> {
            GalacticUIParticle uiParticle = new GalacticUIParticle(20.0f, 1, (float)this.getX() + this.position.x, (float)this.getY() + this.position.y, UIParticle.Layer.SCREEN, 1.0f);
            uiParticle.setScreen(this.screen);
            uiParticle.instantiate();
        };
        this.tween = Tween.create().setTransitionType(this.transitionType).setEase(this.easeType).setLoops(3);
        this.tween.tweenMethod(this::setColor, ShatterColor.GREEN, ShatterColor.WHITE, 0.5).setTransitionType(TransitionType.LINEAR);
        this.tween.parallel().tweenProperty((Object)this, "position", new Vector2f(10.0f, 10.0f), 0.5);
        this.tween.parallel().tweenRunnable(spawnParticle);
        this.tween.tweenInterval(0.5);
        this.tween.tweenMethod(this::setColor, ShatterColor.RED, ShatterColor.WHITE, 0.5).setTransitionType(TransitionType.LINEAR);
        this.tween.parallel().tweenProperty((Object)this, "position", new Vector2f(0.0f, 0.0f), 0.5);
        this.tween.parallel().tweenRunnable(spawnParticle);
        this.tween.tweenInterval(0.5);
        super.onClick(event, isDoubleClick);
    }

    public void setColor(ShatterColor color) {
        this.color = color;
    }
}

