/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.client.particle;

import it.hurts.shatterbyte.shatterlib.client.particle.UIParticle;
import it.hurts.shatterbyte.shatterlib.util.VectorUtils;
import net.minecraft.util.Mth;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class ExtendedUIParticle
extends UIParticle {
    private Vector2f gravityDirection = new Vector2f(0.0f, 1.0f);
    private float gravity = 0.0f;
    private float friction = 0.0f;
    private float angularVelocity = 0.0f;
    private float gravityAccel = 0.0f;

    public ExtendedUIParticle(UIParticle.Texture2D texture, float maxSpeed, int lifetime, float xStart, float yStart, UIParticle.Layer layer, float zOffset) {
        super(texture, maxSpeed, lifetime, xStart, yStart, layer, zOffset);
    }

    public void setGravityDirection(float x, float y) {
        this.gravityDirection = new Vector2f(x, y).normalize();
    }

    public void setGravityDirection(Vector2f gravityDirection) {
        this.gravityDirection = new Vector2f((Vector2fc)gravityDirection).normalize();
    }

    @Override
    public void tick() {
        if (this.isExpired()) {
            return;
        }
        super.tick();
        if (this.angularVelocity != 0.0f) {
            this.setDirection(VectorUtils.rotate(this.getDirection().normalize(), this.angularVelocity));
        } else {
            this.getDirection().normalize();
        }
        this.setSpeed(Mth.clamp((float)(this.getSpeed() * (1.0f - this.friction)), (float)0.0f, (float)this.getMaxSpeed()));
        this.gravityAccel += this.gravity;
        if (this.gravityAccel != 0.0f) {
            this.getTransform().getPosition().add((Vector2fc)new Vector2f((Vector2fc)this.gravityDirection).mul(this.gravityAccel));
        }
    }

    public Vector2f getGravityDirection() {
        return this.gravityDirection;
    }

    public float getGravity() {
        return this.gravity;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    public float getFriction() {
        return this.friction;
    }

    public void setFriction(float friction) {
        this.friction = friction;
    }

    public float getAngularVelocity() {
        return this.angularVelocity;
    }

    public void setAngularVelocity(float angularVelocity) {
        this.angularVelocity = angularVelocity;
    }
}

