/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.client.particle;

import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.hurts.shatterbyte.shatterlib.client.particle.ParticleSystem;
import it.hurts.shatterbyte.shatterlib.client.particle.Transform;
import it.hurts.shatterbyte.shatterlib.util.RenderUtils;
import it.hurts.shatterbyte.shatterlib.util.ShatterColor;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.joml.Vector2f;
import org.joml.Vector2fc;

public class UIParticle {
    public static final RenderPipeline ADDITIVE_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.GUI_TEXTURED_SNIPPET}).withBlend(BlendFunction.LIGHTNING).withColorWrite(true).withLocation(ResourceLocation.fromNamespaceAndPath((String)"shatterlib", (String)"additive")).build();
    private final Texture2D texture;
    private final float maxSpeed;
    private final int lifetime;
    private final Layer layer;
    private Screen screen;
    private final Transform transform;
    private Vector2f direction = new Vector2f(0.0f, 1.0f);
    private float rollVelocity;
    private float speed;
    private int time;
    private float zOffset;
    private ShatterColor[] colors = new ShatterColor[]{ShatterColor.WHITE};
    private RenderPipeline renderPipeline = RenderPipelines.GUI_TEXTURED;
    private Matrix3x2f matrix = new Matrix3x2f();

    public UIParticle(Texture2D texture, float maxSpeed, int lifetime, float xStart, float yStart, Layer layer, float zOffset) {
        this.texture = texture;
        this.maxSpeed = maxSpeed;
        this.lifetime = lifetime;
        this.speed = maxSpeed;
        this.layer = layer;
        this.zOffset = zOffset;
        this.transform = new Transform(new Vector2f(xStart, yStart), 0.0f, new Vector2f(1.0f, 1.0f));
    }

    public void setMatrix(Matrix3x2f matrix) {
        this.matrix = new Matrix3x2f((Matrix3x2fc)matrix);
    }

    public Matrix3x2f getMatrix() {
        return new Matrix3x2f((Matrix3x2fc)this.matrix);
    }

    public void setColors(ShatterColor ... colors) {
        this.colors = colors;
    }

    public void setDirection(float x, float y) {
        this.direction = new Vector2f(x, y).normalize();
    }

    public void setDirection(Vector2f direction) {
        this.direction = new Vector2f((Vector2fc)direction).normalize();
    }

    public boolean isExpired() {
        return this.time >= this.lifetime;
    }

    public boolean isScreen() {
        return this.layer == Layer.SCREEN;
    }

    public boolean isGui() {
        return this.layer == Layer.GUI;
    }

    public void tick() {
        if (this.isExpired()) {
            return;
        }
        this.transform.updateOldValues();
        this.time = Mth.clamp((int)(this.time + 1), (int)0, (int)this.lifetime);
        if (Mth.abs((float)this.speed) > 0.01f) {
            this.transform.getPosition().add((Vector2fc)new Vector2f((Vector2fc)this.direction).mul(this.speed));
        }
        if (Mth.abs((float)this.rollVelocity) > 0.01f) {
            this.transform.setRoll(this.transform.getRoll() + this.rollVelocity);
        }
    }

    public void render(GuiGraphics guiGraphics, float partialTicks) {
        if (this.isExpired()) {
            return;
        }
        Texture2D tex = this.getTexture();
        Matrix3x2f matrix = this.getMatrix();
        this.transformPose(matrix, partialTicks);
        ShatterColor color = this.getColor(partialTicks);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().mul((Matrix3x2fc)matrix);
        RenderUtils.renderTextureFromCenter(this.getRenderPipeline(), tex.rl, guiGraphics, 0.0f, 0.0f, tex.texOffX, tex.texOffY, (int)tex.texWidth, (int)tex.texHeight, tex.width, tex.height, 1.0f, color.getARGB());
        guiGraphics.pose().popMatrix();
    }

    private void transformPose(Matrix3x2f pose, float partialTicks) {
        Vector2f interpPos = this.transform.getInterpolatedPosition(partialTicks);
        float interpRot = this.transform.getInterpolatedRoll(partialTicks);
        Vector2f interpSize = this.transform.getInterpolatedSize(partialTicks);
        pose.translate(interpPos.x, interpPos.y);
        pose.scale(interpSize.x, interpSize.y);
        pose.rotate((float)Math.toRadians(interpRot));
    }

    public float getTimeRatio(float partialTicks) {
        return ((float)this.time + partialTicks) / (float)this.lifetime;
    }

    public ShatterColor getColor(float partialTicks) {
        return ShatterColor.lerp(this.getTimeRatio(partialTicks), this.colors);
    }

    public void instantiate() {
        if (this.isScreen()) {
            if (this.screen == null) {
                return;
            }
            ParticleSystem.SCREEN_PARTICLES.putIfAbsent(this.screen, new ArrayList());
            ParticleSystem.SCREEN_PARTICLES.get(this.screen).add(this);
            return;
        }
        ParticleSystem.GUI_PARTICLES.add(this);
    }

    public Texture2D getTexture() {
        return this.texture;
    }

    public float getMaxSpeed() {
        return this.maxSpeed;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public Layer getLayer() {
        return this.layer;
    }

    public Screen getScreen() {
        return this.screen;
    }

    public void setScreen(Screen screen) {
        this.screen = screen;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public Vector2f getDirection() {
        return this.direction;
    }

    public float getRollVelocity() {
        return this.rollVelocity;
    }

    public void setRollVelocity(float rollVelocity) {
        this.rollVelocity = rollVelocity;
    }

    public float getSpeed() {
        return this.speed;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public int getTime() {
        return this.time;
    }

    public void setTime(int time) {
        this.time = time;
    }

    public float getZOffset() {
        return this.zOffset;
    }

    public void setZOffset(float zOffset) {
        this.zOffset = zOffset;
    }

    public ShatterColor[] getColors() {
        return this.colors;
    }

    public RenderPipeline getRenderPipeline() {
        return this.renderPipeline;
    }

    public void setRenderPipeline(RenderPipeline renderPipeline) {
        this.renderPipeline = renderPipeline;
    }

    public static class Texture2D {
        private ResourceLocation rl;
        private float width;
        private float height;
        private float texOffX;
        private float texOffY;
        private float texWidth;
        private float texHeight;

        public Texture2D(ResourceLocation texture, int texOffX, int texOffY, int texWidth, int texHeight, int width, int height) {
            this.rl = texture;
            this.texOffX = texOffX;
            this.texOffY = texOffY;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.width = width;
            this.height = height;
        }

        public Texture2D(ResourceLocation texture, int width, int height) {
            this(texture, 0, 0, width, height, width, height);
        }

        public ResourceLocation getRl() {
            return this.rl;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public float getTexOffX() {
            return this.texOffX;
        }

        public float getTexOffY() {
            return this.texOffY;
        }

        public float getTexWidth() {
            return this.texWidth;
        }

        public float getTexHeight() {
            return this.texHeight;
        }

        public void setRl(ResourceLocation rl) {
            this.rl = rl;
        }

        public void setWidth(float width) {
            this.width = width;
        }

        public void setHeight(float height) {
            this.height = height;
        }

        public void setTexOffX(float texOffX) {
            this.texOffX = texOffX;
        }

        public void setTexOffY(float texOffY) {
            this.texOffY = texOffY;
        }

        public void setTexWidth(float texWidth) {
            this.texWidth = texWidth;
        }

        public void setTexHeight(float texHeight) {
            this.texHeight = texHeight;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Texture2D)) {
                return false;
            }
            Texture2D other = (Texture2D)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (Float.compare(this.getWidth(), other.getWidth()) != 0) {
                return false;
            }
            if (Float.compare(this.getHeight(), other.getHeight()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexOffX(), other.getTexOffX()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexOffY(), other.getTexOffY()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexWidth(), other.getTexWidth()) != 0) {
                return false;
            }
            if (Float.compare(this.getTexHeight(), other.getTexHeight()) != 0) {
                return false;
            }
            ResourceLocation this$rl = this.getRl();
            ResourceLocation other$rl = other.getRl();
            return !(this$rl == null ? other$rl != null : !this$rl.equals(other$rl));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Texture2D;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + Float.floatToIntBits(this.getWidth());
            result = result * 59 + Float.floatToIntBits(this.getHeight());
            result = result * 59 + Float.floatToIntBits(this.getTexOffX());
            result = result * 59 + Float.floatToIntBits(this.getTexOffY());
            result = result * 59 + Float.floatToIntBits(this.getTexWidth());
            result = result * 59 + Float.floatToIntBits(this.getTexHeight());
            ResourceLocation $rl = this.getRl();
            result = result * 59 + ($rl == null ? 43 : $rl.hashCode());
            return result;
        }

        public String toString() {
            return "UIParticle.Texture2D(rl=" + String.valueOf(this.getRl()) + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", texOffX=" + this.getTexOffX() + ", texOffY=" + this.getTexOffY() + ", texWidth=" + this.getTexWidth() + ", texHeight=" + this.getTexHeight() + ")";
        }
    }

    public static enum Layer {
        GUI,
        SCREEN;

    }
}

