/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.client.screen.widget;

import it.hurts.shatterbyte.shatterlib.mixin.AbstractWidgetAccessor;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public interface Child<T extends LayoutElement>
extends LayoutElement,
GuiEventListener {
    @Nullable
    public T getParent();

    public void setParent(@Nullable T var1);

    default public int getLocalX() {
        Child child = this;
        if (child instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)child;
            return ((AbstractWidgetAccessor)widget).getLocalX();
        }
        return 0;
    }

    default public int getLocalY() {
        Child child = this;
        if (child instanceof AbstractWidget) {
            AbstractWidget widget = (AbstractWidget)child;
            return ((AbstractWidgetAccessor)widget).getLocalY();
        }
        return 0;
    }

    default public Vector2i getLocalPosition() {
        return new Vector2i(this.getLocalX(), this.getLocalY());
    }

    default public Vector2i getParentPosition() {
        T parent = this.getParent();
        return parent != null ? new Vector2i(parent.getX(), parent.getY()) : new Vector2i(0, 0);
    }

    default public Vector2i getPosition() {
        Vector2i parentPos = this.getParentPosition();
        return new Vector2i(this.getLocalX() + parentPos.x, this.getLocalY() + parentPos.y);
    }

    @NotNull
    default public ScreenRectangle getRectangle() {
        return super.getRectangle();
    }

    default public void detachWidget() {
        Vector2i globalPos = this.getPosition();
        this.setParent(null);
        this.setPosition(globalPos.x, globalPos.y);
    }

    default public void attachWidget(@Nullable T parent) {
        Vector2i globalPos = this.getPosition();
        this.setParent(parent);
        Vector2i parentPos = this.getParentPosition();
        this.setPosition(globalPos.x - parentPos.x, globalPos.y - parentPos.y);
    }
}

