/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.client.screen.widget;

import it.hurts.shatterbyte.shatterlib.client.animation.Tween;
import it.hurts.shatterbyte.shatterlib.client.animation.easing.EaseType;
import it.hurts.shatterbyte.shatterlib.client.animation.easing.TransitionType;
import it.hurts.shatterbyte.shatterlib.client.screen.widget.HasRenderMatrix;
import it.hurts.shatterbyte.shatterlib.client.screen.widget.TestPin;
import it.hurts.shatterbyte.shatterlib.util.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;

public class TestGear
extends AbstractWidget
implements HasRenderMatrix,
ContainerEventHandler {
    private Matrix3x2f renderMatrix;
    Tween tween = Tween.create();
    private float rot;
    List<GuiEventListener> children = new ArrayList<GuiEventListener>();

    public TestGear(int x, int y) {
        super(x, y, 128, 128, (Component)Component.empty());
        this.children.add(new TestPin(16, 16, this));
    }

    @Override
    public Matrix3x2f getMatrix() {
        return this.renderMatrix;
    }

    @Override
    public void setMatrix(Matrix3x2f matrix) {
        this.renderMatrix = matrix;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.getX() + (float)this.width / 2.0f, (float)this.getY() + (float)this.height / 2.0f);
        guiGraphics.pose().rotate((float)Math.toRadians(this.rot));
        guiGraphics.pose().translate((float)(-this.width) / 2.0f - (float)this.getX(), (float)(-this.height) / 2.0f - (float)this.getY());
        this.setMatrix(new Matrix3x2f((Matrix3x2fc)guiGraphics.pose()));
        RenderUtils.renderOutline(guiGraphics, this.getX(), this.getY(), this.width, this.height, -1);
        this.children().forEach(child -> {
            if (child instanceof Renderable) {
                Renderable renderable = (Renderable)child;
                renderable.render(guiGraphics, mouseX, mouseY, partialTick);
            }
        });
        guiGraphics.pose().popMatrix();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean isDoubleClick) {
        boolean result = super.mouseClicked(event, isDoubleClick);
        if (!super.mouseClicked(event, isDoubleClick) && result) {
            this.tween.kill();
            this.tween = Tween.create();
            this.tween.tweenMethod(this::setRot, Float.valueOf(this.rot), Float.valueOf(this.rot + 60.0f), 0.75).setEaseType(EaseType.EASE_OUT).setTransitionType(TransitionType.QUART);
            this.tween.start();
            return true;
        }
        return false;
    }

    public List<? extends GuiEventListener> children() {
        return this.children;
    }

    public boolean isDragging() {
        return false;
    }

    public void setDragging(boolean isDragging) {
    }

    @Nullable
    public GuiEventListener getFocused() {
        return null;
    }

    public void setFocused(@Nullable GuiEventListener focused) {
    }

    public void setRot(float rot) {
        this.rot = rot;
    }
}

