/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.client.screen.widget;

import it.hurts.shatterbyte.shatterlib.client.animation.Tween;
import it.hurts.shatterbyte.shatterlib.client.screen.widget.Child;
import it.hurts.shatterbyte.shatterlib.client.screen.widget.HasRenderMatrix;
import it.hurts.shatterbyte.shatterlib.client.screen.widget.TestGear;
import it.hurts.shatterbyte.shatterlib.util.RenderUtils;
import it.hurts.shatterbyte.shatterlib.util.ShatterColor;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;

public class TestPin
extends AbstractWidget
implements Child<TestGear> {
    ShatterColor color = ShatterColor.GREEN;
    TestGear parent;

    public TestPin(int x, int y, TestGear parent) {
        super(x, y, 24, 24, (Component)Component.empty());
        this.setParent(parent);
        this.setPosition(x, y);
    }

    @Override
    @Nullable
    public TestGear getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable TestGear parent) {
        this.parent = parent;
    }

    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.isHovered() && this.color == ShatterColor.GREEN) {
            this.color = ShatterColor.BLUE;
        } else if (!this.isHovered() && this.color == ShatterColor.BLUE) {
            this.color = ShatterColor.GREEN;
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.getX(), (float)this.getY());
        RenderUtils.renderOutline(guiGraphics, 0, 0, this.width, this.height, this.color.getARGB());
        guiGraphics.pose().popMatrix();
        TestGear testGear = this.getParent();
        if (testGear instanceof HasRenderMatrix) {
            TestGear has = testGear;
            guiGraphics.pose().pushMatrix();
            Vec2 bleh = RenderUtils.toScreenCoords(has.getMatrix(), mouseX, mouseY);
            guiGraphics.pose().translate((float)((double)bleh.x - 0.5), (float)((double)bleh.y - 0.5));
            RenderUtils.renderOutline(guiGraphics, 0, 0, 2, 2, -65536);
            guiGraphics.pose().popMatrix();
        }
    }

    public void onClick(MouseButtonEvent event, boolean isDoubleClick) {
        super.onClick(event, isDoubleClick);
        Tween tween = Tween.create();
        tween.tweenMethod(this::setColor, ShatterColor.RED, ShatterColor.GREEN, 0.5);
        tween.start();
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void setColor(ShatterColor color) {
        this.color = color;
    }
}

