/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.shatterbyte.shatterlib.module.config.util;

import com.mojang.datafixers.util.Pair;
import it.hurts.shatterbyte.shatterlib.ShatterLib;
import it.hurts.shatterbyte.shatterlib.module.config.ConfigManager;
import it.hurts.shatterbyte.shatterlib.module.config.annotation.registration.AnnotationConfigFactory;
import it.hurts.shatterbyte.shatterlib.module.config.annotation.registration.ConfigNameGetter;
import it.hurts.shatterbyte.shatterlib.module.config.impl.ShatterConfig;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.logging.log4j.util.Cast;

public final class ConfigUtils {
    public static void registerFieldConfig(Field field, String dir) {
        field.setAccessible(true);
        try {
            Object value = field.get(null);
            if (value == null) {
                ShatterLib.LOGGER.warn("Failed to load config in " + dir + " directory: config is null.");
            }
            for (Annotation a : field.getAnnotations()) {
                Pair<AnnotationConfigFactory<?>, ConfigNameGetter<?>> fabric = ConfigManager.getConfigFactory(a.annotationType());
                if (fabric == null) {
                    ShatterLib.LOGGER.warn("Unsupported annotation {} for config initialization.", (Object)a);
                    continue;
                }
                ShatterConfig shatterConfig = ((AnnotationConfigFactory)fabric.getFirst()).create((Annotation)Cast.cast((Object)a), value);
                String name = ((ConfigNameGetter)fabric.getSecond()).getName((Annotation)Cast.cast((Object)a), value);
                String location = dir + "/" + name;
                ConfigManager.registerConfig(location, shatterConfig);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private ConfigUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

