/*
 * Decompiled with CFR 0.152.
 */
package hu.jgj52.hutierstagger.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import hu.jgj52.hutierstagger.client.ConfigFile;
import hu.jgj52.hutierstagger.client.InventoryManager;
import hu.jgj52.hutierstagger.client.PlayerPrefixManager;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1799;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2873;
import net.minecraft.class_310;

@Environment(value=EnvType.CLIENT)
public class HutierstaggerClient
implements ClientModInitializer {
    private String gamemode;
    private static boolean enabled;
    private static HutierstaggerClient instance;
    private static final HttpClient client;

    public void onInitializeClient() {
        instance = this;
        ConfigFile.load();
        this.gamemode = ConfigFile.get("gamemode", "Vanilla");
        enabled = Boolean.parseBoolean(ConfigFile.get("enabled", "true"));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"setgamemode").then(ClientCommandManager.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(Set.of("Vanilla", "UHC", "Pot", "NethPot", "SMP", "Sword", "Axe", "Mace", "Cart", "Creeper", "DiaSMP", "OGVanilla", "ShieldlessUHC"), (SuggestionsBuilder)builder)).executes(context -> {
            String mode = StringArgumentType.getString((CommandContext)context, (String)"mode");
            if (!List.of("Vanilla", "UHC", "Pot", "NethPot", "SMP", "Sword", "Axe", "Mace", "Cart", "Creeper", "DiaSMP", "OGVanilla", "ShieldlessUHC").contains(mode)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cNincs ilyen gamemode!"));
                return 0;
            }
            this.gamemode = mode;
            ConfigFile.set("gamemode", mode);
            PlayerPrefixManager.resetMap();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aGamemode be\u00e1ll\u00edtva erre: " + mode)));
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"getgamemodekit").then(ClientCommandManager.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> class_2172.method_9265(Set.of("Vanilla", "UHC", "Pot", "NethPot", "SMP", "Sword", "Axe", "Mace", "Cart", "Creeper", "DiaSMP", "OGVanilla", "ShieldlessUHC"), (SuggestionsBuilder)builder)).executes(context -> {
            String mode = StringArgumentType.getString((CommandContext)context, (String)"mode");
            if (!List.of("Vanilla", "UHC", "Pot", "NethPot", "SMP", "Sword", "Axe", "Mace", "Cart", "Creeper", "DiaSMP", "OGVanilla", "ShieldlessUHC").contains(mode)) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cNincs ilyen gamemode!"));
                return 0;
            }
            if (class_310.method_1551() == null || class_310.method_1551().field_1724 == null) {
                return 0;
            }
            if (!class_310.method_1551().field_1724.method_7337()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7cKreat\u00edvban kell lenned!"));
                return 0;
            }
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(new URI("https://api.hutiers.hu/v2/gamemode/kit/" + mode)).GET().build();
                HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
                class_1799[] items = InventoryManager.itemStackArrayFromBase64(response.body());
                for (int i = 0; i < items.length && i <= 40; ++i) {
                    class_310.method_1551().field_1724.method_31548().method_5447(i, items[i]);
                    int serverSlot = i < 9 ? i + 36 : (i < 36 ? i : (i == 36 ? 8 : (i == 37 ? 7 : (i == 38 ? 6 : (i == 39 ? 5 : 45)))));
                    class_310.method_1551().method_1562().method_52787((class_2596)new class_2873(serverSlot, items[i]));
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7aGamemode kitj\u00e9t megkaptad: " + mode)));
            return 1;
        }))));
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"togglehutierstagger").executes(context -> {
            enabled = !enabled;
            ConfigFile.set("enabled", String.valueOf(enabled));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aSikeresen \u00e1t\u00e1ll\u00edtva!"));
            return 1;
        })));
    }

    public String getGamemode() {
        return this.gamemode;
    }

    public static boolean getEnabled() {
        return enabled;
    }

    public static HutierstaggerClient getInstance() {
        return instance;
    }

    static {
        client = HttpClient.newHttpClient();
    }
}

