/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.survivalreimagined.init;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.mcreator.survivalreimagined.jei_recipes.AAFJEIRecipe;
import net.mcreator.survivalreimagined.jei_recipes.AAFJEIRecipeCategory;
import net.mcreator.survivalreimagined.jei_recipes.ForgingRecipe;
import net.mcreator.survivalreimagined.jei_recipes.ForgingRecipeCategory;
import net.mcreator.survivalreimagined.jei_recipes.MetalRefiningRecipe;
import net.mcreator.survivalreimagined.jei_recipes.MetalRefiningRecipeCategory;
import net.mcreator.survivalreimagined.jei_recipes.ProcessingRecipe;
import net.mcreator.survivalreimagined.jei_recipes.ProcessingRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;

@JeiPlugin
public class SurvivalReimaginedModJeiPlugin
implements IModPlugin {
    public static RecipeType<ForgingRecipe> Forging_Type = new RecipeType(ForgingRecipeCategory.UID, ForgingRecipe.class);
    public static RecipeType<MetalRefiningRecipe> MetalRefining_Type = new RecipeType(MetalRefiningRecipeCategory.UID, MetalRefiningRecipe.class);
    public static RecipeType<ProcessingRecipe> Processing_Type = new RecipeType(ProcessingRecipeCategory.UID, ProcessingRecipe.class);
    public static RecipeType<AAFJEIRecipe> AAFJEI_Type = new RecipeType(AAFJEIRecipeCategory.UID, AAFJEIRecipe.class);

    public ResourceLocation getPluginUid() {
        return ResourceLocation.parse((String)"survival_reimagined:jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new ForgingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new MetalRefiningRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new ProcessingRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new AAFJEIRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Objects.requireNonNull(Minecraft.getInstance().level).getRecipeManager();
        List ForgingRecipes = recipeManager.getAllRecipesFor(ForgingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(Forging_Type, ForgingRecipes);
        List MetalRefiningRecipes = recipeManager.getAllRecipesFor(MetalRefiningRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(MetalRefining_Type, MetalRefiningRecipes);
        List ProcessingRecipes = recipeManager.getAllRecipesFor(ProcessingRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(Processing_Type, ProcessingRecipes);
        List AAFJEIRecipes = recipeManager.getAllRecipesFor(AAFJEIRecipe.Type.INSTANCE).stream().map(RecipeHolder::value).collect(Collectors.toList());
        registration.addRecipes(AAFJEI_Type, AAFJEIRecipes);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
    }
}

