/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.survivalreimagined.item;

import io.netty.buffer.Unpooled;
import java.util.List;
import net.mcreator.survivalreimagined.procedures.AAFScriptureSpecialInformationProcedure;
import net.mcreator.survivalreimagined.world.inventory.AAFScriptureGUIMenu;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AAFScriptureItem
extends Item {
    public AAFScriptureItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.UNCOMMON));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        Entity entity = itemstack.getEntityRepresentation() != null ? itemstack.getEntityRepresentation() : Minecraft.getInstance().player;
        String hoverText = AAFScriptureSpecialInformationProcedure.execute();
        if (hoverText != null) {
            for (String line : hoverText.split("\n")) {
                list.add((Component)Component.literal((String)line));
            }
        }
    }

    public InteractionResultHolder<ItemStack> use(Level world, final Player entity, final InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Ancient Book Scripture");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(entity.blockPosition());
                    packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    return new AAFScriptureGUIMenu(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.writeBlockPos(entity.blockPosition());
                buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
            });
        }
        return ar;
    }
}

