/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.survivalreimagined.block;

import net.mcreator.survivalreimagined.procedures.ClayCrucibleBlockValidPlacementConditionProcedure;
import net.mcreator.survivalreimagined.procedures.ClayCrucibleEntityWalksOnTheBlockProcedure;
import net.mcreator.survivalreimagined.procedures.ClayCrucibleOnRandomClientDisplayTickProcedure;
import net.mcreator.survivalreimagined.procedures.ClayCrucibleOnTickUpdateProcedure;
import net.mcreator.survivalreimagined.procedures.DayDetectionProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ClayCrucibleBlock
extends Block {
    public static final BooleanProperty CAN_BURN = BooleanProperty.create((String)"can_burn");

    public ClayCrucibleBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.MUD).instabreak().noCollission().noOcclusion().isRedstoneConductor((bs, br, bp) -> false));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)CAN_BURN, (Comparable)Boolean.valueOf(false)));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return true;
    }

    public int getLightBlock(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return 0;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return Shapes.or((VoxelShape)ClayCrucibleBlock.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)1.0, (double)12.0), (VoxelShape[])new VoxelShape[]{ClayCrucibleBlock.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)9.0, (double)4.0), ClayCrucibleBlock.box((double)3.0, (double)3.0, (double)12.0, (double)13.0, (double)9.0, (double)13.0), ClayCrucibleBlock.box((double)3.0, (double)3.0, (double)4.0, (double)4.0, (double)9.0, (double)12.0), ClayCrucibleBlock.box((double)12.0, (double)3.0, (double)4.0, (double)13.0, (double)9.0, (double)12.0), ClayCrucibleBlock.box((double)11.0, (double)1.0, (double)4.0, (double)12.0, (double)3.0, (double)12.0), ClayCrucibleBlock.box((double)5.0, (double)1.0, (double)11.0, (double)11.0, (double)3.0, (double)12.0), ClayCrucibleBlock.box((double)4.0, (double)1.0, (double)4.0, (double)5.0, (double)3.0, (double)12.0), ClayCrucibleBlock.box((double)5.0, (double)1.0, (double)4.0, (double)11.0, (double)3.0, (double)5.0)});
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{CAN_BURN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)super.getStateForPlacement(context).setValue((Property)CAN_BURN, (Comparable)Boolean.valueOf(false));
    }

    public boolean canSurvive(BlockState blockstate, LevelReader worldIn, BlockPos pos) {
        if (worldIn instanceof LevelAccessor) {
            LevelAccessor world = (LevelAccessor)worldIn;
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return ClayCrucibleBlockValidPlacementConditionProcedure.execute(world, x, y, z);
        }
        return super.canSurvive(blockstate, worldIn, pos);
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos currentPos, BlockPos facingPos) {
        return !state.canSurvive((LevelReader)world, currentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, facing, facingState, world, currentPos, facingPos);
    }

    public PathType getBlockPathType(BlockState state, BlockGetter world, BlockPos pos, Mob entity) {
        return PathType.WALKABLE;
    }

    public void onPlace(BlockState blockstate, Level world, BlockPos pos, BlockState oldState, boolean moving) {
        super.onPlace(blockstate, world, pos, oldState, moving);
        world.scheduleTick(pos, (Block)this, 120);
        DayDetectionProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }

    public void tick(BlockState blockstate, ServerLevel world, BlockPos pos, RandomSource random) {
        super.tick(blockstate, world, pos, random);
        ClayCrucibleOnTickUpdateProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
        world.scheduleTick(pos, (Block)this, 120);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState blockstate, Level world, BlockPos pos, RandomSource random) {
        super.animateTick(blockstate, world, pos, random);
        LocalPlayer entity = Minecraft.getInstance().player;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        ClayCrucibleOnRandomClientDisplayTickProcedure.execute((LevelAccessor)world, x, y, z, blockstate);
    }

    public void entityInside(BlockState blockstate, Level world, BlockPos pos, Entity entity) {
        super.entityInside(blockstate, world, pos, entity);
        ClayCrucibleEntityWalksOnTheBlockProcedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ());
    }
}

