/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.night.better_sword_trims.command.ReloadCommand;
import net.night.better_sword_trims.util.TrimEffectHelper;

@Mod.EventBusSubscriber(modid="better_sword_trims")
public class ModEvents {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ReloadCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack weapon;
        Entity entity = event.getSource().m_7640_();
        if (entity instanceof LivingEntity && !(weapon = (attacker = (LivingEntity)entity).m_21205_()).m_41619_() && weapon.m_41720_().toString().contains("sword")) {
            TrimEffectHelper.applyTrimEffect(weapon, event.getEntity(), attacker);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        int originalXp;
        LivingEntity entity = event.getEntity();
        int finalXp = originalXp = event.getDroppedExperience();
        Set tags = entity.m_19880_();
        if (tags.contains("better_sword_trims:quartz_kill")) {
            finalXp = originalXp * 2;
            entity.m_20137_("better_sword_trims:quartz_kill");
        }
        String prefix = "better_sword_trims:extra_xp_";
        for (String tag : tags) {
            if (!tag.startsWith(prefix)) continue;
            String num = tag.substring(prefix.length());
            try {
                int add = Integer.parseInt(num);
                finalXp += add;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            entity.m_20137_(tag);
        }
        event.setDroppedExperience(finalXp);
    }
}

