/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModItems;

public class TrimmedSwordItem
extends SwordItem {
    private final ModItems.TrimMaterial trimMaterial;
    private final String configKey;
    private final SwordConfig cfg;

    public TrimmedSwordItem(int baseDurability, int actualDurability, float attackDamage, float attackSpeed, ModItems.TrimMaterial trimMaterial, String configKey, Item.Properties properties) {
        super((Tier)new CustomTier(actualDurability, attackDamage - 1.0f), (int)attackDamage - 1, attackSpeed, properties);
        this.trimMaterial = trimMaterial;
        this.configKey = configKey;
        this.cfg = ConfigManager.getConfig(configKey);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!target.m_9236_().f_46443_) {
            this.applyTrimEffect(stack, target, attacker);
        }
        return super.m_7579_(stack, target, attacker);
    }

    private void applyTrimEffect(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ServerLevel level = (ServerLevel)target.m_9236_();
        switch (this.trimMaterial) {
            case LAPIS: {
                int glowTicks = (int)(this.cfg.highlights.durationSeconds * 20.0);
                if (glowTicks > 0) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, glowTicks, this.cfg.highlights == null ? 0 : 0));
                }
                this.highlightSameTypeEntities(target, level, glowTicks);
                break;
            }
            case QUARTZ: {
                target.m_20049_("better_sword_trims:quartz_kill");
                int extraXp = this.cfg == null ? 0 : this.cfg.experience;
                target.m_20049_("better_sword_trims:extra_xp_" + extraXp);
                break;
            }
            case COPPER: {
                break;
            }
            case EMERALD: {
                int levAmp;
                int levTicks = (int)(this.cfg.levitation.durationSeconds * 20.0);
                int n = levAmp = this.cfg == null ? 0 : this.cfg.levitation.amplifier;
                if (levTicks <= 0) break;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, levTicks, levAmp));
                break;
            }
            case REDSTONE: {
                int slowAmp;
                int slowTicks = (int)(this.cfg.slowness.durationSeconds * 20.0);
                int n = slowAmp = this.cfg == null ? 0 : this.cfg.slowness.amplifier;
                if (slowTicks <= 0) break;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slowTicks, slowAmp));
                break;
            }
            case WEEPING_OBSIDIAN: {
                this.applyAreaDamage(stack, target, attacker, level);
            }
        }
    }

    private void highlightSameTypeEntities(LivingEntity target, ServerLevel level, int glowTicks) {
        EntityType targetType = target.m_6095_();
        AABB searchArea = target.m_20191_().m_82400_(32.0);
        List nearbyEntities = level.m_6443_(LivingEntity.class, searchArea, entity -> entity.m_6095_() == targetType && entity != target);
        for (LivingEntity entity2 : nearbyEntities) {
            if (glowTicks <= 0) continue;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, glowTicks, 0));
        }
    }

    private void applyAreaDamage(ItemStack stack, LivingEntity target, LivingEntity attacker, ServerLevel level) {
        AABB damageArea = target.m_20191_().m_82400_(3.0);
        float baseDamage = (float)attacker.m_21133_(Attributes.f_22281_);
        List nearbyEntities = level.m_6443_(LivingEntity.class, damageArea, entity -> entity != target && entity != attacker && entity.m_6084_());
        double configured = this.cfg == null ? 0.0 : this.cfg.areaDamage.amount;
        for (LivingEntity entity2 : nearbyEntities) {
            float damage;
            double distance = entity2.m_20270_((Entity)target);
            if (configured > 0.0) {
                damage = (float)configured;
            } else {
                float damageMultiplier = (float)(1.0 - distance / 3.0 * 0.5);
                damage = baseDamage * damageMultiplier * 0.5f;
            }
            entity2.m_6469_(level.m_269111_().m_269333_(attacker), damage);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123766_, entity2.m_20185_(), entity2.m_20186_() + (double)entity2.m_20206_() * 0.5, entity2.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.m_237113_((String)"Upgrade:").m_130940_(ChatFormatting.GRAY));
        String materialName = switch (this.trimMaterial) {
            default -> throw new IncompatibleClassChangeError();
            case ModItems.TrimMaterial.QUARTZ -> "Quartz";
            case ModItems.TrimMaterial.EMERALD -> "Emerald";
            case ModItems.TrimMaterial.LAPIS -> "Lapis Lazuli";
            case ModItems.TrimMaterial.WEEPING_OBSIDIAN -> "Crying Obsidian";
            case ModItems.TrimMaterial.REDSTONE -> "Redstone";
            case ModItems.TrimMaterial.COPPER -> "Copper";
        };
        tooltipComponents.add((Component)Component.m_237113_((String)(" " + materialName + " Material")).m_130940_(this.trimMaterial.getColor()));
        tooltipComponents.add((Component)Component.m_237113_((String)(" " + this.trimMaterial.getDescription())).m_130940_(this.trimMaterial.getColor()));
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
    }

    public ModItems.TrimMaterial getTrimMaterial() {
        return this.trimMaterial;
    }

    private static class CustomTier
    implements Tier {
        private final int durability;
        private final float attackDamage;

        public CustomTier(int durability, float attackDamage) {
            this.durability = durability;
            this.attackDamage = attackDamage;
        }

        public int m_6609_() {
            return this.durability;
        }

        public float m_6624_() {
            return 8.0f;
        }

        public float m_6631_() {
            return this.attackDamage;
        }

        public int m_6604_() {
            return 3;
        }

        public int m_6601_() {
            return 14;
        }

        public Ingredient m_6282_() {
            return Ingredient.f_43901_;
        }
    }
}

