/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.mixin;

import net.minecraft.core.RegistryAccess;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingTransformRecipe.class})
public class SmithingTransformRecipeMixin {
    @Inject(method={"assemble"}, at={@At(value="RETURN")}, cancellable=true)
    private void onAssemble(Container container, RegistryAccess registryAccess, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = (ItemStack)cir.getReturnValue();
        ItemStack base = container.m_8020_(1);
        ItemStack template = container.m_8020_(0);
        ItemStack addition = container.m_8020_(2);
        if (!result.m_41619_() && this.better_sword_trims$isSword(result) && this.better_sword_trims$isSpikeTemplate(template)) {
            String ingredientId = this.better_sword_trims$getIngredientId(addition);
            if (ingredientId != null) {
                String swordType;
                String swordType2;
                ModDataComponents.SwordTrimComponent oldTrim = ModDataComponents.getTrim(base);
                if (oldTrim != null && "minecraft:copper_ingot".equals(oldTrim.getIngredient()) && (swordType2 = this.better_sword_trims$getSwordType(result)) != null) {
                    String configKey = swordType2 + "_copper";
                    SwordConfig cfg = ConfigManager.getConfig(configKey);
                    int currentMaxDurability = result.m_41776_();
                    int currentDamage = result.m_41773_();
                    int baseDurability = (int)((double)currentMaxDurability / cfg.durabilityMultiplier);
                    int newDamage = Math.min(currentDamage, baseDurability - 1);
                    result.m_41784_().m_128473_("MaxDamage");
                    result.m_41721_(newDamage);
                }
                ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(ingredientId);
                ModDataComponents.setTrim(result, trimComponent);
                if ("minecraft:copper_ingot".equals(ingredientId) && (swordType = this.better_sword_trims$getSwordType(result)) != null) {
                    String configKey = swordType + "_copper";
                    SwordConfig cfg = ConfigManager.getConfig(configKey);
                    int baseDurability = result.m_41776_();
                    int currentDamage = result.m_41773_();
                    int newMaxDurability = (int)((double)baseDurability * cfg.durabilityMultiplier);
                    result.m_41784_().m_128405_("MaxDamage", newMaxDurability);
                    result.m_41721_(currentDamage);
                }
                cir.setReturnValue((Object)result);
            } else {
                ModDataComponents.SwordTrimComponent baseTrim = ModDataComponents.getTrim(base);
                if (baseTrim != null) {
                    ModDataComponents.setTrim(result, baseTrim);
                }
                cir.setReturnValue((Object)result);
            }
        }
    }

    @Unique
    private boolean better_sword_trims$isSword(ItemStack stack) {
        return stack.m_41720_() == Items.f_42383_ || stack.m_41720_() == Items.f_42430_ || stack.m_41720_() == Items.f_42388_ || stack.m_41720_() == Items.f_42393_;
    }

    @Unique
    private boolean better_sword_trims$isSpikeTemplate(ItemStack stack) {
        return stack.m_41720_().toString().contains("spike_armor_trim_smithing_template");
    }

    @Unique
    private String better_sword_trims$getIngredientId(ItemStack stack) {
        if (stack.m_41720_() == Items.f_151052_) {
            return "minecraft:copper_ingot";
        }
        if (stack.m_41720_() == Items.f_42616_) {
            return "minecraft:emerald";
        }
        if (stack.m_41720_() == Items.f_42534_) {
            return "minecraft:lapis_lazuli";
        }
        if (stack.m_41720_() == Items.f_42692_) {
            return "minecraft:quartz";
        }
        if (stack.m_41720_() == Items.f_42451_) {
            return "minecraft:redstone";
        }
        if (stack.m_41720_() == Items.f_42754_) {
            return "minecraft:crying_obsidian";
        }
        return null;
    }

    @Unique
    private String better_sword_trims$getSwordType(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42393_) {
            return "netherite";
        }
        if (stack.m_41720_() == Items.f_42388_) {
            return "diamond";
        }
        if (stack.m_41720_() == Items.f_42430_) {
            return "golden";
        }
        if (stack.m_41720_() == Items.f_42383_) {
            return "iron";
        }
        return null;
    }
}

