/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.level.Level;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModRecipes;

public class SwordTrimTransformRecipe
implements SmithingRecipe {
    private final ResourceLocation id;
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;
    private final String ingredientId;

    public SwordTrimTransformRecipe(ResourceLocation id, Ingredient template, Ingredient base, Ingredient addition, String ingredientId) {
        this.id = id;
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.ingredientId = ingredientId;
    }

    public boolean m_5818_(Container container, Level level) {
        return this.template.test(container.m_8020_(0)) && this.base.test(container.m_8020_(1)) && this.addition.test(container.m_8020_(2));
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        String swordType;
        String swordType2;
        ItemStack baseStack = container.m_8020_(1);
        ItemStack resultStack = baseStack.m_41777_();
        ModDataComponents.SwordTrimComponent oldTrim = ModDataComponents.getTrim(baseStack);
        if (oldTrim != null && "minecraft:copper_ingot".equals(oldTrim.getIngredient()) && (swordType2 = this.getSwordType(resultStack)) != null) {
            String configKey = swordType2 + "_copper";
            SwordConfig cfg = ConfigManager.getConfig(configKey);
            int currentMaxDurability = resultStack.m_41776_();
            int currentDamage = resultStack.m_41773_();
            int baseDurability = (int)((double)currentMaxDurability / cfg.durabilityMultiplier);
            int newDamage = Math.min(currentDamage, baseDurability - 1);
            resultStack.m_41784_().m_128473_("MaxDamage");
            resultStack.m_41721_(newDamage);
        }
        ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(this.ingredientId);
        ModDataComponents.setTrim(resultStack, trimComponent);
        if ("minecraft:copper_ingot".equals(this.ingredientId) && (swordType = this.getSwordType(resultStack)) != null) {
            String configKey = swordType + "_copper";
            SwordConfig cfg = ConfigManager.getConfig(configKey);
            int baseDurability = resultStack.m_41776_();
            int currentDamage = resultStack.m_41773_();
            int newMaxDurability = (int)((double)baseDurability * cfg.durabilityMultiplier);
            resultStack.m_41784_().m_128405_("MaxDamage", newMaxDurability);
            resultStack.m_41721_(currentDamage);
        }
        return resultStack;
    }

    private String getSwordType(ItemStack stack) {
        if (stack.m_41720_() == Items.f_42393_) {
            return "netherite";
        }
        if (stack.m_41720_() == Items.f_42388_) {
            return "diamond";
        }
        if (stack.m_41720_() == Items.f_42430_) {
            return "golden";
        }
        if (stack.m_41720_() == Items.f_42383_) {
            return "iron";
        }
        return null;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_266166_(ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean m_266343_(ItemStack stack) {
        return this.base.test(stack);
    }

    public boolean m_266253_(ItemStack stack) {
        return this.addition.test(stack);
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)ModRecipes.SWORD_TRIM_TRANSFORM_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModRecipes.SWORD_TRIM_TRANSFORM_TYPE.get();
    }

    public boolean m_142505_() {
        return this.template.m_43947_() || this.base.m_43947_() || this.addition.m_43947_();
    }

    public static class Serializer
    implements RecipeSerializer<SwordTrimTransformRecipe> {
        public SwordTrimTransformRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            Ingredient template = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"template"));
            Ingredient base = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"base"));
            Ingredient addition = Ingredient.m_43917_((JsonElement)GsonHelper.m_13930_((JsonObject)json, (String)"addition"));
            String ingredientId = GsonHelper.m_13906_((JsonObject)json, (String)"ingredient_id");
            return new SwordTrimTransformRecipe(recipeId, template, base, addition, ingredientId);
        }

        public SwordTrimTransformRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient template = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient base = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            Ingredient addition = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            String ingredientId = buffer.m_130277_();
            return new SwordTrimTransformRecipe(recipeId, template, base, addition, ingredientId);
        }

        public void toNetwork(FriendlyByteBuf buffer, SwordTrimTransformRecipe recipe) {
            recipe.template.m_43923_(buffer);
            recipe.base.m_43923_(buffer);
            recipe.addition.m_43923_(buffer);
            buffer.m_130070_(recipe.ingredientId);
        }
    }
}

