/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.util;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModItems;

public class TrimEffectHelper {
    public static ModItems.TrimMaterial getTrimMaterialFromIngredient(String ingredient) {
        return switch (ingredient) {
            case "minecraft:crying_obsidian" -> ModItems.TrimMaterial.WEEPING_OBSIDIAN;
            case "minecraft:lapis_lazuli" -> ModItems.TrimMaterial.LAPIS;
            case "minecraft:emerald" -> ModItems.TrimMaterial.EMERALD;
            case "minecraft:quartz" -> ModItems.TrimMaterial.QUARTZ;
            case "minecraft:redstone" -> ModItems.TrimMaterial.REDSTONE;
            case "minecraft:copper_ingot" -> ModItems.TrimMaterial.COPPER;
            default -> null;
        };
    }

    public static String getSwordTypeFromItem(ItemStack stack) {
        String itemId = stack.m_41720_().toString();
        if (itemId.contains("netherite_sword")) {
            return "netherite";
        }
        if (itemId.contains("diamond_sword")) {
            return "diamond";
        }
        if (itemId.contains("golden_sword")) {
            return "golden";
        }
        if (itemId.contains("iron_sword")) {
            return "iron";
        }
        return null;
    }

    public static void applyTrimEffect(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level;
        ModDataComponents.SwordTrimComponent trimComponent = ModDataComponents.getTrim(stack);
        if (trimComponent == null) {
            return;
        }
        ModItems.TrimMaterial trimMaterial = TrimEffectHelper.getTrimMaterialFromIngredient(trimComponent.getIngredient());
        if (trimMaterial == null) {
            return;
        }
        String swordType = TrimEffectHelper.getSwordTypeFromItem(stack);
        if (swordType == null) {
            return;
        }
        String configKey = swordType + "_" + trimMaterial.getName();
        SwordConfig cfg = ConfigManager.getConfig(configKey);
        if (!target.m_9236_().f_46443_ && (level = target.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            TrimEffectHelper.applyEffect(trimMaterial, cfg, stack, target, attacker, level2);
        }
    }

    private static void applyEffect(ModItems.TrimMaterial trimMaterial, SwordConfig cfg, ItemStack stack, LivingEntity target, LivingEntity attacker, ServerLevel level) {
        switch (trimMaterial) {
            case LAPIS: {
                int glowTicks = (int)(cfg.highlights.durationSeconds * 20.0);
                if (glowTicks > 0) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19619_, glowTicks, 0));
                }
                TrimEffectHelper.highlightSameTypeEntities(target, level, glowTicks);
                break;
            }
            case QUARTZ: {
                target.m_20049_("better_sword_trims:quartz_kill");
                int extraXp = cfg == null ? 0 : cfg.experience;
                target.m_20049_("better_sword_trims:extra_xp_" + extraXp);
                break;
            }
            case COPPER: {
                break;
            }
            case EMERALD: {
                int levAmp;
                int levTicks = (int)(cfg.levitation.durationSeconds * 20.0);
                int n = levAmp = cfg == null ? 0 : cfg.levitation.amplifier;
                if (levTicks <= 0) break;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19620_, levTicks, levAmp));
                break;
            }
            case REDSTONE: {
                int slowAmp;
                int slowTicks = (int)(cfg.slowness.durationSeconds * 20.0);
                int n = slowAmp = cfg == null ? 0 : cfg.slowness.amplifier;
                if (slowTicks <= 0) break;
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slowTicks, slowAmp));
                break;
            }
            case WEEPING_OBSIDIAN: {
                TrimEffectHelper.applyAreaDamage(stack, target, attacker, level, cfg);
            }
        }
    }

    private static void highlightSameTypeEntities(LivingEntity target, ServerLevel level, int glowTicks) {
        EntityType targetType = target.m_6095_();
        AABB searchArea = target.m_20191_().m_82400_(32.0);
        List nearbyEntities = level.m_6443_(LivingEntity.class, searchArea, entity -> entity.m_6095_() == targetType && entity != target);
        for (LivingEntity entity2 : nearbyEntities) {
            if (glowTicks <= 0) continue;
            entity2.m_7292_(new MobEffectInstance(MobEffects.f_19619_, glowTicks, 0));
        }
    }

    private static void applyAreaDamage(ItemStack stack, LivingEntity target, LivingEntity attacker, ServerLevel level, SwordConfig cfg) {
        AABB damageArea = target.m_20191_().m_82400_(3.0);
        float baseDamage = (float)attacker.m_21133_(Attributes.f_22281_);
        List nearbyEntities = level.m_6443_(LivingEntity.class, damageArea, entity -> entity != target && entity != attacker && entity.m_6084_());
        double configured = cfg == null ? 0.0 : cfg.areaDamage.amount;
        for (LivingEntity entity2 : nearbyEntities) {
            float damage;
            double distance = entity2.m_20270_((Entity)target);
            if (configured > 0.0) {
                damage = (float)configured;
            } else {
                float damageMultiplier = (float)(1.0 - distance / 3.0 * 0.5);
                damage = baseDamage * damageMultiplier * 0.5f;
            }
            entity2.m_6469_(level.m_269111_().m_269333_(attacker), damage);
            level.m_8767_((ParticleOptions)ParticleTypes.f_123766_, entity2.m_20185_(), entity2.m_20186_() + (double)entity2.m_20206_() * 0.5, entity2.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }
}

