/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims;

import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModItems;
import net.night.better_sword_trims.swords.ModLootModifiers;
import net.night.better_sword_trims.swords.ModRecipes;

@Mod(value="better_sword_trims")
public class Better_sword_trims {
    public static final String MOD_ID = "better_sword_trims";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"better_sword_trims");
    public static final RegistryObject<CreativeModeTab> BETTER_SWORD_TRIMS_TAB = CREATIVE_MODE_TABS.register("better_sword_trims_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.better_sword_trims")).icon(() -> {
        ItemStack stack = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        stack.set((DataComponentType)ModDataComponents.TRIM.get(), (Object)new ModDataComponents.SwordTrimComponent("minecraft:emerald"));
        return stack;
    }).withTabsBefore(new ResourceKey[]{CreativeModeTabs.SPAWN_EGGS}).displayItems((parameters, output) -> {
        Item[] swords;
        String[] materials = new String[]{"minecraft:crying_obsidian", "minecraft:lapis_lazuli", "minecraft:emerald", "minecraft:quartz", "minecraft:redstone", "minecraft:copper_ingot"};
        for (Item sword : swords = new Item[]{Items.NETHERITE_SWORD, Items.DIAMOND_SWORD, Items.GOLDEN_SWORD, Items.IRON_SWORD}) {
            for (String material : materials) {
                String swordType;
                ItemStack stack = new ItemStack((ItemLike)sword);
                stack.set((DataComponentType)ModDataComponents.TRIM.get(), (Object)new ModDataComponents.SwordTrimComponent(material));
                if (material.equals("minecraft:copper_ingot") && (swordType = Better_sword_trims.getSwordType(sword)) != null) {
                    String configKey = swordType + "_copper";
                    SwordConfig cfg = ConfigManager.getConfig(configKey);
                    int baseDurability = stack.getMaxDamage();
                    int newMaxDurability = (int)((double)baseDurability * cfg.durabilityMultiplier);
                    stack.set(DataComponents.MAX_DAMAGE, (Object)newMaxDurability);
                }
                output.accept(stack);
            }
        }
        output.accept((ItemLike)ModItems.SPIKE_ARMOR_TRIM_SMITHING_TEMPLATE.get());
    }).build());

    private static String getSwordType(Item sword) {
        if (sword == Items.NETHERITE_SWORD) {
            return "netherite";
        }
        if (sword == Items.DIAMOND_SWORD) {
            return "diamond";
        }
        if (sword == Items.GOLDEN_SWORD) {
            return "golden";
        }
        if (sword == Items.IRON_SWORD) {
            return "iron";
        }
        return null;
    }

    public Better_sword_trims() {
        this(Better_sword_trims.getModEventBus());
    }

    private static IEventBus getModEventBus() {
        return FMLJavaModLoadingContext.get().getModEventBus();
    }

    public Better_sword_trims(IEventBus modEventBus) {
        ConfigManager.load();
        ModItems.ITEMS.register(modEventBus);
        ModDataComponents.DATA_COMPONENTS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        ModRecipes.RECIPE_SERIALIZERS.register(modEventBus);
        ModRecipes.RECIPE_TYPES.register(modEventBus);
        ModLootModifiers.LOOT_MODIFIERS.register(modEventBus);
    }
}

