/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.client;

import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.night.better_sword_trims.component.ModDataComponents;

@Mod.EventBusSubscriber(modid="better_sword_trims", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemPropertiesRegistry {
    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            ItemPropertiesRegistry.registerSwordProperties(Items.IRON_SWORD);
            ItemPropertiesRegistry.registerSwordProperties(Items.DIAMOND_SWORD);
            ItemPropertiesRegistry.registerSwordProperties(Items.GOLDEN_SWORD);
            ItemPropertiesRegistry.registerSwordProperties(Items.NETHERITE_SWORD);
        });
    }

    private static void registerSwordProperties(Item sword) {
        ItemProperties.register((Item)sword, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"better_sword_trims", (String)"trim_emerald"), (stack, level, entity, seed) -> {
            ModDataComponents.SwordTrimComponent trim = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
            return trim != null && trim.getIngredient().equals("minecraft:emerald") ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)sword, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"better_sword_trims", (String)"trim_lapis"), (stack, level, entity, seed) -> {
            ModDataComponents.SwordTrimComponent trim = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
            return trim != null && trim.getIngredient().equals("minecraft:lapis_lazuli") ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)sword, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"better_sword_trims", (String)"trim_quartz"), (stack, level, entity, seed) -> {
            ModDataComponents.SwordTrimComponent trim = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
            return trim != null && trim.getIngredient().equals("minecraft:quartz") ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)sword, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"better_sword_trims", (String)"trim_redstone"), (stack, level, entity, seed) -> {
            ModDataComponents.SwordTrimComponent trim = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
            return trim != null && trim.getIngredient().equals("minecraft:redstone") ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)sword, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"better_sword_trims", (String)"trim_copper"), (stack, level, entity, seed) -> {
            ModDataComponents.SwordTrimComponent trim = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
            return trim != null && trim.getIngredient().equals("minecraft:copper_ingot") ? 1.0f : 0.0f;
        });
        ItemProperties.register((Item)sword, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"better_sword_trims", (String)"trim_weeping_obsidian"), (stack, level, entity, seed) -> {
            ModDataComponents.SwordTrimComponent trim = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
            return trim != null && trim.getIngredient().equals("minecraft:crying_obsidian") ? 1.0f : 0.0f;
        });
    }
}

