/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.config;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.fml.loading.FMLPaths;
import net.night.better_sword_trims.config.SwordConfig;

public class ConfigManager {
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("Better_Sword_Trims.toml");
    private static final Map<String, SwordConfig> CONFIGS = new HashMap<String, SwordConfig>();
    private static SwordConfig DEFAULTS = new SwordConfig();
    private static final String DEFAULT_TOML = "# Better Sword Trims\n# Configure the swords in the mod.\n# Use '/bst reload' to reload the configuration.\n# Durability only changes by restarting the game. \n\n[defaults]\n# Configure the durability multiplier. Default: 1.5 (150% durability)\nDurability = 1.5\n# Configure the quartz upgrade experience. Default: 5\nExperience = 5\n# Configure redstone upgrade slowness. Default: 5 seconds / amplifier 1\nSlowness = { duration = 5, amplifier = 1 }\n# Configure the levitation of the emerald upgrade. Default: 4 seconds / amplifier 1\nLevitation = { duration = 4, amplifier = 1 }\n# Configure the glow on mobs for the lapis lazuli upgrade. Default: 45 seconds\nHighlights = { duration = 45 }\n# Set the damage area of the Crying Obsidian upgrade. Default: 3.0\nAreaDamage = { amount = 3.0 }\n";

    public static void load() {
        CONFIGS.clear();
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            System.out.println("[Better_Sword_Trims] Config file not found, creating default at: " + String.valueOf(CONFIG_PATH.toAbsolutePath()));
            try {
                if (CONFIG_PATH.getParent() != null) {
                    Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                }
                Files.writeString(CONFIG_PATH, (CharSequence)DEFAULT_TOML, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (IOException ex) {
                System.out.println("[Better_Sword_Trims] Failed to create default config: " + ex.getMessage());
                return;
            }
        }
        try {
            String content = Files.readString(CONFIG_PATH, StandardCharsets.UTF_8);
            Object parseResult = null;
            try {
                Class<?> tomlClass = Class.forName("org.tomlj.Toml");
                Method parseMethod = tomlClass.getMethod("parse", String.class);
                parseResult = parseMethod.invoke(null, content);
            }
            catch (ClassNotFoundException cnfe) {
                System.out.println("[Better_Sword_Trims] tomlj not found on classpath; attempting manual parse fallback.");
                ConfigManager.parseDefaultsFromContent(content);
                ConfigManager.parseSwordTablesFromContent(content);
            }
            if (parseResult == null) {
                System.out.println("[Better_Sword_Trims] Using manually parsed config values: " + ConfigManager.defaultsSummary(DEFAULTS));
                return;
            }
            Class<?> resultClass = parseResult.getClass();
            Method hasErrorsMethod = resultClass.getMethod("hasErrors", new Class[0]);
            Boolean hasErrors = (Boolean)hasErrorsMethod.invoke(parseResult, new Object[0]);
            if (hasErrors.booleanValue()) {
                Method errorsMethod = resultClass.getMethod("errors", new Class[0]);
                Object errs = errorsMethod.invoke(parseResult, new Object[0]);
                System.out.println("[Better_Sword_Trims] Errors parsing TOML config: " + String.valueOf(errs));
                ConfigManager.parseDefaultsFromContent(content);
                ConfigManager.parseSwordTablesFromContent(content);
                System.out.println("[Better_Sword_Trims] Falling back to manual parse: " + ConfigManager.defaultsSummary(DEFAULTS));
                return;
            }
            Method toMapMethod = resultClass.getMethod("toMap", new Class[0]);
            Map top = (Map)toMapMethod.invoke(parseResult, new Object[0]);
            if (top.containsKey("defaults") && top.get("defaults") instanceof Map) {
                Map d = (Map)top.get("defaults");
                DEFAULTS = ConfigManager.parseSwordDefaults(d);
            }
            if (top.containsKey("swords") && top.get("swords") instanceof Map) {
                Map swords = (Map)top.get("swords");
                for (Map.Entry e : swords.entrySet()) {
                    String key = (String)e.getKey();
                    Object val = e.getValue();
                    if (!(val instanceof Map)) continue;
                    Map table = (Map)val;
                    SwordConfig cfg = ConfigManager.parseSwordTable(table, DEFAULTS);
                    CONFIGS.put(key, cfg);
                }
            }
            System.out.println("[Better_Sword_Trims] Loaded sword configs: " + String.valueOf(CONFIGS.keySet()));
        }
        catch (IOException ex) {
            System.out.println("[Better_Sword_Trims] Failed to read config: " + ex.getMessage());
        }
        catch (ReflectiveOperationException rex) {
            System.out.println("[Better_Sword_Trims] Reflection error while parsing TOML: " + rex.getMessage());
        }
    }

    private static void parseDefaultsFromContent(String content) {
        Double aAmount;
        String areaContents;
        Double hDuration;
        String highContents;
        String levContents;
        String slowContents;
        Double exp;
        int idx = content.indexOf("[defaults]");
        if (idx < 0) {
            return;
        }
        String after = content.substring(idx);
        int nextSection = after.indexOf("\n[");
        String section = nextSection >= 0 ? after.substring(0, nextSection) : after;
        Pattern simpleNum = Pattern.compile("(?m)^[ \t]*%s[ \t]*=[ \t]*([0-9]+(?:\\.[0-9]+)?)");
        Pattern inlineTable = Pattern.compile("(?m)^[ \t]*%s[ \t]*=[ \t]*\\{([^}]*)\\}");
        Double dur = ConfigManager.extractSimpleDouble(section, String.format(simpleNum.pattern(), "Durability"));
        if (dur != null) {
            ConfigManager.DEFAULTS.durabilityMultiplier = dur;
        }
        if ((exp = ConfigManager.extractSimpleDouble(section, String.format(simpleNum.pattern(), "Experience"))) != null) {
            ConfigManager.DEFAULTS.experience = exp.intValue();
        }
        if ((slowContents = ConfigManager.extractInlineTable(section, String.format(inlineTable.pattern(), "Slowness"))) != null) {
            Double sDuration = ConfigManager.extractSimpleDouble(slowContents, "(?m)^[ \t]*duration[ \t]*=[ \t]*([0-9]+(?:\\.[0-9]+)?)");
            Double sAmpl = ConfigManager.extractSimpleDouble(slowContents, "(?m)^[ \t]*amplifier[ \t]*=[ \t]*([0-9]+)");
            if (sDuration != null) {
                ConfigManager.DEFAULTS.slowness.durationSeconds = sDuration;
            }
            if (sAmpl != null) {
                ConfigManager.DEFAULTS.slowness.amplifier = sAmpl.intValue();
            }
        }
        if ((levContents = ConfigManager.extractInlineTable(section, String.format(inlineTable.pattern(), "Levitation"))) != null) {
            Double lDuration = ConfigManager.extractSimpleDouble(levContents, "(?m)^[ \t]*duration[ \t]*=[ \t]*([0-9]+(?:\\.[0-9]+)?)");
            Double lAmpl = ConfigManager.extractSimpleDouble(levContents, "(?m)^[ \t]*amplifier[ \t]*=[ \t]*([0-9]+)");
            if (lDuration != null) {
                ConfigManager.DEFAULTS.levitation.durationSeconds = lDuration;
            }
            if (lAmpl != null) {
                ConfigManager.DEFAULTS.levitation.amplifier = lAmpl.intValue();
            }
        }
        if ((highContents = ConfigManager.extractInlineTable(section, String.format(inlineTable.pattern(), "Highlights"))) != null && (hDuration = ConfigManager.extractSimpleDouble(highContents, "(?m)^[ \t]*duration[ \t]*=[ \t]*([0-9]+(?:\\.[0-9]+)?)")) != null) {
            ConfigManager.DEFAULTS.highlights.durationSeconds = hDuration;
        }
        if ((areaContents = ConfigManager.extractInlineTable(section, String.format(inlineTable.pattern(), "AreaDamage"))) != null && (aAmount = ConfigManager.extractSimpleDouble(areaContents, "(?m)^[ \t]*amount[ \t]*=[ \t]*([0-9]+(?:\\.[0-9]+)?)")) != null) {
            ConfigManager.DEFAULTS.areaDamage.amount = aAmount;
        }
    }

    private static String extractInlineTable(String text, String pattern) {
        Pattern p = Pattern.compile(pattern, 8);
        Matcher m = p.matcher(text);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private static Double extractSimpleDouble(String text, String pattern) {
        Pattern p = Pattern.compile(pattern, 8);
        Matcher m = p.matcher(text);
        if (m.find()) {
            try {
                return Double.parseDouble(m.group(1));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static String defaultsSummary(SwordConfig d) {
        return String.format("durabilityMult=%.1f, experience=%d, slowness={duration=%.1f,amp=%d}, levitation={duration=%.1f,amp=%d}, highlights=%.1f, areaDamage=%.1f", d.durabilityMultiplier, d.experience, d.slowness.durationSeconds, d.slowness.amplifier, d.levitation.durationSeconds, d.levitation.amplifier, d.highlights.durationSeconds, d.areaDamage.amount);
    }

    public static SwordConfig getConfig(String key) {
        return CONFIGS.getOrDefault(key, DEFAULTS);
    }

    private static SwordConfig parseSwordDefaults(Map<String, Object> d) {
        SwordConfig def = new SwordConfig();
        def.durabilityMultiplier = ConfigManager.getDoubleFromMap(d, "Durability", def.durabilityMultiplier);
        def.experience = ConfigManager.getIntFromMap(d, "Experience", def.experience);
        def.slowness.durationSeconds = ConfigManager.getDoubleFromNested(d, "Slowness", "duration", def.slowness.durationSeconds);
        def.slowness.amplifier = ConfigManager.getIntFromNested(d, "Slowness", "amplifier", def.slowness.amplifier);
        def.levitation.durationSeconds = ConfigManager.getDoubleFromNested(d, "Levitation", "duration", def.levitation.durationSeconds);
        def.levitation.amplifier = ConfigManager.getIntFromNested(d, "Levitation", "amplifier", def.levitation.amplifier);
        def.highlights.durationSeconds = ConfigManager.getDoubleFromNested(d, "Highlights", "duration", def.highlights.durationSeconds);
        def.areaDamage.amount = ConfigManager.getDoubleFromNested(d, "AreaDamage", "amount", def.areaDamage.amount);
        return def;
    }

    private static SwordConfig parseSwordTable(Map<String, Object> table, SwordConfig defaults) {
        SwordConfig cfg = new SwordConfig();
        cfg.durabilityMultiplier = ConfigManager.getDoubleFromMap(table, "Durability", defaults.durabilityMultiplier);
        cfg.experience = ConfigManager.getIntFromMap(table, "Experience", defaults.experience);
        cfg.slowness.durationSeconds = ConfigManager.getDoubleFromNested(table, "Slowness", "duration", defaults.slowness.durationSeconds);
        cfg.slowness.amplifier = ConfigManager.getIntFromNested(table, "Slowness", "amplifier", defaults.slowness.amplifier);
        cfg.levitation.durationSeconds = ConfigManager.getDoubleFromNested(table, "Levitation", "duration", defaults.levitation.durationSeconds);
        cfg.levitation.amplifier = ConfigManager.getIntFromNested(table, "Levitation", "amplifier", defaults.levitation.amplifier);
        cfg.highlights.durationSeconds = ConfigManager.getDoubleFromNested(table, "Highlights", "duration", defaults.highlights.durationSeconds);
        cfg.areaDamage.amount = ConfigManager.getDoubleFromNested(table, "AreaDamage", "amount", defaults.areaDamage.amount);
        return cfg;
    }

    private static int getIntFromMap(Map<String, Object> map, String key, int fallback) {
        if (!map.containsKey(key)) {
            return fallback;
        }
        Object o = map.get(key);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    private static double getDoubleFromMap(Map<String, Object> map, String key, double fallback) {
        if (!map.containsKey(key)) {
            return fallback;
        }
        Object o = map.get(key);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    private static int getIntFromNested(Map<String, Object> map, String tableKey, String key, int fallback) {
        if (!map.containsKey(tableKey)) {
            return fallback;
        }
        Object t = map.get(tableKey);
        if (!(t instanceof Map)) {
            return fallback;
        }
        Map nested = (Map)t;
        return ConfigManager.getIntFromMap(nested, key, fallback);
    }

    private static double getDoubleFromNested(Map<String, Object> map, String tableKey, String key, double fallback) {
        if (!map.containsKey(tableKey)) {
            return fallback;
        }
        Object t = map.get(tableKey);
        if (!(t instanceof Map)) {
            return fallback;
        }
        Map nested = (Map)t;
        if (!nested.containsKey(key)) {
            return fallback;
        }
        Object o = nested.get(key);
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (Exception ex) {
            return fallback;
        }
    }

    private static void parseSwordTablesFromContent(String content) {
        Pattern p = Pattern.compile("(?m)^\\[swords\\.([A-Za-z0-9_]+)\\]");
        Matcher m = p.matcher(content);
        while (m.find()) {
            Double aAmount;
            String areaContents;
            Double hDuration;
            String highContents;
            String levContents;
            String slowContents;
            Double exp;
            String key = m.group(1);
            int start = m.start();
            String after = content.substring(start);
            int nextSection = after.indexOf("\n[");
            String section = nextSection >= 0 ? after.substring(0, nextSection) : after;
            SwordConfig cfg = new SwordConfig();
            Double dur = ConfigManager.extractSimpleDouble(section, "(?m)^[ \\t]*Durability[ \\t]*=[ \\t]*([0-9]+(?:\\.[0-9]+)?)");
            if (dur != null) {
                cfg.durabilityMultiplier = dur;
            }
            if ((exp = ConfigManager.extractSimpleDouble(section, "(?m)^[ \\t]*Experience[ \\t]*=[ \\t]*([0-9]+(?:\\.[0-9]+)?)")) != null) {
                cfg.experience = exp.intValue();
            }
            if ((slowContents = ConfigManager.extractInlineTable(section, "(?m)^[ \\t]*Slowness[ \\t]*=[ \\t]*\\{([^}]*)\\}")) != null) {
                Double sDuration = ConfigManager.extractSimpleDouble(slowContents, "(?m)duration[ \\t]*=[ \\t]*([0-9]+(?:\\.[0-9]+)?)");
                Double sAmpl = ConfigManager.extractSimpleDouble(slowContents, "(?m)amplifier[ \\t]*=[ \\t]*([0-9]+)");
                if (sDuration != null) {
                    cfg.slowness.durationSeconds = sDuration;
                }
                if (sAmpl != null) {
                    cfg.slowness.amplifier = sAmpl.intValue();
                }
            }
            if ((levContents = ConfigManager.extractInlineTable(section, "(?m)^[ \\t]*Levitation[ \\t]*=[ \\t]*\\{([^}]*)\\}")) != null) {
                Double lDuration = ConfigManager.extractSimpleDouble(levContents, "(?m)duration[ \\t]*=[ \\t]*([0-9]+(?:\\.[0-9]+)?)");
                Double lAmpl = ConfigManager.extractSimpleDouble(levContents, "(?m)amplifier[ \\t]*=[ \\t]*([0-9]+)");
                if (lDuration != null) {
                    cfg.levitation.durationSeconds = lDuration;
                }
                if (lAmpl != null) {
                    cfg.levitation.amplifier = lAmpl.intValue();
                }
            }
            if ((highContents = ConfigManager.extractInlineTable(section, "(?m)^[ \\t]*Highlights[ \\t]*=[ \\t]*\\{([^}]*)\\}")) != null && (hDuration = ConfigManager.extractSimpleDouble(highContents, "(?m)duration[ \\t]*=[ \\t]*([0-9]+(?:\\.[0-9]+)?)")) != null) {
                cfg.highlights.durationSeconds = hDuration;
            }
            if ((areaContents = ConfigManager.extractInlineTable(section, "(?m)^[ \\t]*AreaDamage[ \\t]*=[ \\t]*\\{([^}]*)\\}")) != null && (aAmount = ConfigManager.extractSimpleDouble(areaContents, "(?m)amount[ \\t]*=[ \\t]*([0-9]+(?:\\.[0-9]+)?)")) != null) {
                cfg.areaDamage.amount = aAmount;
            }
            CONFIGS.put(key, cfg);
        }
    }

    static {
        DEFAULTS = new SwordConfig();
        ConfigManager.DEFAULTS.highlights.durationSeconds = 45.0;
        ConfigManager.DEFAULTS.levitation.durationSeconds = 4.0;
        ConfigManager.DEFAULTS.slowness.durationSeconds = 5.0;
        ConfigManager.DEFAULTS.slowness.amplifier = 1;
        ConfigManager.DEFAULTS.durabilityMultiplier = 1.5;
        ConfigManager.DEFAULTS.experience = 5;
        ConfigManager.DEFAULTS.areaDamage.amount = 3.0;
    }
}

