/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.event;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.swords.ModItems;
import net.night.better_sword_trims.util.TrimEffectHelper;

@Mod.EventBusSubscriber(modid="better_sword_trims", value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        if (stack.getItem().toString().contains("sword")) {
            ModItems.TrimMaterial trimMaterial;
            List tooltip = event.getToolTip();
            tooltip.removeIf(component -> {
                String text = component.getString();
                return text.contains("Upgrade:") && !text.equals("Upgrade:") || text.contains("Spike Armor Trim") || text.contains("Material") && !text.contains("Doubles") && !text.contains("More") && !text.contains("Wither") && !text.contains("Regeneration") && !text.contains("Life Steal");
            });
            ModDataComponents.SwordTrimComponent trimComponent = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
            if (trimComponent != null && (trimMaterial = TrimEffectHelper.getTrimMaterialFromIngredient(trimComponent.getIngredient())) != null) {
                int insertPosition = 1;
                String materialName = switch (trimMaterial) {
                    default -> throw new MatchException(null, null);
                    case ModItems.TrimMaterial.QUARTZ -> "Quartz";
                    case ModItems.TrimMaterial.EMERALD -> "Emerald";
                    case ModItems.TrimMaterial.LAPIS -> "Lapis Lazuli";
                    case ModItems.TrimMaterial.WEEPING_OBSIDIAN -> "Crying Obsidian";
                    case ModItems.TrimMaterial.REDSTONE -> "Redstone";
                    case ModItems.TrimMaterial.COPPER -> "Copper";
                };
                tooltip.add(insertPosition++, Component.literal((String)"Upgrade:").withStyle(ChatFormatting.GRAY));
                tooltip.add(insertPosition++, Component.literal((String)(" " + materialName + " Material")).withStyle(trimMaterial.getColor()));
                tooltip.add(insertPosition, Component.literal((String)(" " + trimMaterial.getDescription())).withStyle(trimMaterial.getColor()));
            }
        }
    }
}

