/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.night.better_sword_trims.command.ReloadCommand;
import net.night.better_sword_trims.swords.ModItems;
import net.night.better_sword_trims.util.TrimEffectHelper;

@Mod.EventBusSubscriber(modid="better_sword_trims")
public class ModEvents {
    private static final Map<String, Float> LOOT_TABLES = new HashMap<String, Float>();

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ReloadCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent event) {
        LivingEntity attacker;
        ItemStack weapon;
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof LivingEntity && !(weapon = (attacker = (LivingEntity)entity).getMainHandItem()).isEmpty() && weapon.getItem().toString().contains("sword")) {
            TrimEffectHelper.applyTrimEffect(weapon, event.getEntity(), attacker);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        int originalXp;
        LivingEntity entity = event.getEntity();
        int finalXp = originalXp = event.getDroppedExperience();
        Set tags = entity.getTags();
        if (tags.contains("better_sword_trims:quartz_kill")) {
            finalXp = originalXp * 2;
            entity.removeTag("better_sword_trims:quartz_kill");
        }
        String prefix = "better_sword_trims:extra_xp_";
        for (String tag : tags) {
            if (!tag.startsWith(prefix)) continue;
            String num = tag.substring(prefix.length());
            try {
                int add = Integer.parseInt(num);
                finalXp += add;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            entity.removeTag(tag);
        }
        event.setDroppedExperience(finalXp);
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent event) {
        String tablePath = event.getName().toString();
        if (LOOT_TABLES.containsKey(tablePath)) {
            float chance = LOOT_TABLES.get(tablePath).floatValue();
            LootPool.Builder poolBuilder = LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).when(LootItemRandomChanceCondition.randomChance((float)chance)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)((ItemLike)ModItems.SPIKE_ARMOR_TRIM_SMITHING_TEMPLATE.get())));
            event.getTable().addPool(poolBuilder.build());
        }
    }

    static {
        LOOT_TABLES.put("minecraft:chests/end_city_treasure", Float.valueOf(0.03f));
        LOOT_TABLES.put("minecraft:chests/ancient_city", Float.valueOf(0.02f));
        LOOT_TABLES.put("minecraft:chests/bastion_treasure", Float.valueOf(0.02f));
        LOOT_TABLES.put("minecraft:chests/desert_pyramid", Float.valueOf(0.02f));
        LOOT_TABLES.put("minecraft:chests/jungle_temple", Float.valueOf(0.02f));
        LOOT_TABLES.put("minecraft:chests/nether_bridge", Float.valueOf(0.02f));
        LOOT_TABLES.put("minecraft:chests/stronghold_corridor", Float.valueOf(0.025f));
        LOOT_TABLES.put("minecraft:chests/stronghold_library", Float.valueOf(0.025f));
        LOOT_TABLES.put("minecraft:chests/woodland_mansion", Float.valueOf(0.015f));
    }
}

