/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModItems;

public class TrimmedSwordItem
extends SwordItem {
    private final ModItems.TrimMaterial trimMaterial;
    private final String configKey;
    private final SwordConfig cfg;

    public TrimmedSwordItem(int baseDurability, int actualDurability, float attackDamage, float attackSpeed, ModItems.TrimMaterial trimMaterial, String configKey, Item.Properties properties) {
        super((Tier)new CustomTier(actualDurability, 0.0f), properties.attributes(SwordItem.createAttributes((Tier)new CustomTier(actualDurability, 0.0f), (int)((int)attackDamage - 1), (float)attackSpeed)));
        this.trimMaterial = trimMaterial;
        this.configKey = configKey;
        this.cfg = ConfigManager.getConfig(configKey);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!target.level().isClientSide) {
            this.applyTrimEffect(stack, target, attacker);
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    private void applyTrimEffect(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        ServerLevel level = (ServerLevel)target.level();
        switch (this.trimMaterial) {
            case LAPIS: {
                int glowTicks = (int)(this.cfg.highlights.durationSeconds * 20.0);
                if (glowTicks > 0) {
                    target.addEffect(new MobEffectInstance(MobEffects.GLOWING, glowTicks, this.cfg.highlights == null ? 0 : 0));
                }
                this.highlightSameTypeEntities(target, level, glowTicks);
                break;
            }
            case QUARTZ: {
                target.addTag("better_sword_trims:quartz_kill");
                int extraXp = this.cfg == null ? 0 : this.cfg.experience;
                target.addTag("better_sword_trims:extra_xp_" + extraXp);
                break;
            }
            case COPPER: {
                break;
            }
            case EMERALD: {
                int levAmp;
                int levTicks = (int)(this.cfg.levitation.durationSeconds * 20.0);
                int n = levAmp = this.cfg == null ? 0 : this.cfg.levitation.amplifier;
                if (levTicks <= 0) break;
                target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, levTicks, levAmp));
                break;
            }
            case REDSTONE: {
                int slowAmp;
                int slowTicks = (int)(this.cfg.slowness.durationSeconds * 20.0);
                int n = slowAmp = this.cfg == null ? 0 : this.cfg.slowness.amplifier;
                if (slowTicks <= 0) break;
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slowTicks, slowAmp));
                break;
            }
            case WEEPING_OBSIDIAN: {
                this.applyAreaDamage(stack, target, attacker, level);
            }
        }
    }

    private void highlightSameTypeEntities(LivingEntity target, ServerLevel level, int glowTicks) {
        EntityType targetType = target.getType();
        AABB searchArea = target.getBoundingBox().inflate(32.0);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, searchArea, entity -> entity.getType() == targetType && entity != target);
        for (LivingEntity entity2 : nearbyEntities) {
            if (glowTicks <= 0) continue;
            entity2.addEffect(new MobEffectInstance(MobEffects.GLOWING, glowTicks, 0));
        }
    }

    private void applyAreaDamage(ItemStack stack, LivingEntity target, LivingEntity attacker, ServerLevel level) {
        AABB damageArea = target.getBoundingBox().inflate(3.0);
        float baseDamage = (float)attacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, damageArea, entity -> entity != target && entity != attacker && entity.isAlive());
        double configured = this.cfg == null ? 0.0 : this.cfg.areaDamage.amount;
        for (LivingEntity entity2 : nearbyEntities) {
            float damage;
            double distance = entity2.distanceTo((Entity)target);
            if (configured > 0.0) {
                damage = (float)configured;
            } else {
                float damageMultiplier = (float)(1.0 - distance / 3.0 * 0.5);
                damage = baseDamage * damageMultiplier * 0.5f;
            }
            entity2.hurt(level.damageSources().mobAttack(attacker), damage);
            level.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, entity2.getX(), entity2.getY() + (double)entity2.getBbHeight() * 0.5, entity2.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.literal((String)"Upgrade:").withStyle(ChatFormatting.GRAY));
        String materialName = switch (this.trimMaterial) {
            default -> throw new MatchException(null, null);
            case ModItems.TrimMaterial.QUARTZ -> "Quartz";
            case ModItems.TrimMaterial.EMERALD -> "Emerald";
            case ModItems.TrimMaterial.LAPIS -> "Lapis Lazuli";
            case ModItems.TrimMaterial.WEEPING_OBSIDIAN -> "Crying Obsidian";
            case ModItems.TrimMaterial.REDSTONE -> "Redstone";
            case ModItems.TrimMaterial.COPPER -> "Copper";
        };
        tooltipComponents.add((Component)Component.literal((String)(" " + materialName + " Material")).withStyle(this.trimMaterial.getColor()));
        tooltipComponents.add((Component)Component.literal((String)(" " + this.trimMaterial.getDescription())).withStyle(this.trimMaterial.getColor()));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public ModItems.TrimMaterial getTrimMaterial() {
        return this.trimMaterial;
    }

    private static class CustomTier
    implements Tier {
        private final int durability;
        private final float attackDamage;

        public CustomTier(int durability, float attackDamage) {
            this.durability = durability;
            this.attackDamage = attackDamage;
        }

        public int getUses() {
            return this.durability;
        }

        public float getSpeed() {
            return 8.0f;
        }

        public float getAttackDamageBonus() {
            return this.attackDamage;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return null;
        }

        public int getEnchantmentValue() {
            return 14;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.EMPTY;
        }
    }
}

