/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.mixin;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingTransformRecipe.class})
public class SmithingTransformRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/SmithingRecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private void onAssemble(SmithingRecipeInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = (ItemStack)cir.getReturnValue();
        ItemStack base = input.base();
        if (!result.isEmpty() && this.better_sword_trims$isSword(result)) {
            String swordType;
            ModDataComponents.SwordTrimComponent oldTrim = (ModDataComponents.SwordTrimComponent)base.get((DataComponentType)ModDataComponents.TRIM.get());
            ModDataComponents.SwordTrimComponent newTrim = (ModDataComponents.SwordTrimComponent)result.get((DataComponentType)ModDataComponents.TRIM.get());
            if (oldTrim != null && "minecraft:copper_ingot".equals(oldTrim.getIngredient()) && (newTrim == null || !"minecraft:copper_ingot".equals(newTrim.getIngredient()))) {
                String swordType2 = this.better_sword_trims$getSwordType(result);
                if (swordType2 != null) {
                    String configKey = swordType2 + "_copper";
                    SwordConfig cfg = ConfigManager.getConfig(configKey);
                    int baseMaxDurability = base.getMaxDamage();
                    int originalDurability = (int)((double)baseMaxDurability / cfg.durabilityMultiplier);
                    int baseDamage = base.getDamageValue();
                    float damageRatio = baseMaxDurability > 0 ? (float)baseDamage / (float)baseMaxDurability : 0.0f;
                    result.set(DataComponents.MAX_DAMAGE, (Object)originalDurability);
                    result.setDamageValue((int)((float)originalDurability * damageRatio));
                }
            } else if (newTrim != null && "minecraft:copper_ingot".equals(newTrim.getIngredient()) && (oldTrim == null || !"minecraft:copper_ingot".equals(oldTrim.getIngredient())) && (swordType = this.better_sword_trims$getSwordType(result)) != null) {
                String configKey = swordType + "_copper";
                SwordConfig cfg = ConfigManager.getConfig(configKey);
                int currentDurability = result.getMaxDamage();
                int newMaxDurability = (int)((double)currentDurability * cfg.durabilityMultiplier);
                int currentDamage = result.getDamageValue();
                float damageRatio = currentDurability > 0 ? (float)currentDamage / (float)currentDurability : 0.0f;
                result.set(DataComponents.MAX_DAMAGE, (Object)newMaxDurability);
                result.setDamageValue((int)((float)newMaxDurability * damageRatio));
            }
        }
    }

    @Unique
    private boolean better_sword_trims$isSword(ItemStack stack) {
        return stack.getItem() == Items.IRON_SWORD || stack.getItem() == Items.GOLDEN_SWORD || stack.getItem() == Items.DIAMOND_SWORD || stack.getItem() == Items.NETHERITE_SWORD;
    }

    @Unique
    private String better_sword_trims$getSwordType(ItemStack stack) {
        if (stack.getItem() == Items.NETHERITE_SWORD) {
            return "netherite";
        }
        if (stack.getItem() == Items.DIAMOND_SWORD) {
            return "diamond";
        }
        if (stack.getItem() == Items.GOLDEN_SWORD) {
            return "golden";
        }
        if (stack.getItem() == Items.IRON_SWORD) {
            return "iron";
        }
        return null;
    }
}

