/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.mixin;

import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SmithingTrimRecipe.class})
public class SmithingTrimRecipeMixin {
    @Inject(method={"assemble(Lnet/minecraft/world/item/crafting/SmithingRecipeInput;Lnet/minecraft/core/HolderLookup$Provider;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="RETURN")})
    private void onAssemble(SmithingRecipeInput input, HolderLookup.Provider registries, CallbackInfoReturnable<ItemStack> cir) {
        ItemStack result = (ItemStack)cir.getReturnValue();
        ItemStack template = input.template();
        ItemStack addition = input.addition();
        ItemStack base = input.base();
        if (!result.isEmpty() && this.better_sword_trims$isSword(result) && !template.isEmpty() && template.getItem().toString().contains("spike_armor_trim_smithing_template")) {
            String trimMaterial = this.better_sword_trims$getTrimMaterialFromItem(addition);
            if (trimMaterial != null) {
                ModDataComponents.SwordTrimComponent oldTrim = (ModDataComponents.SwordTrimComponent)base.get((DataComponentType)ModDataComponents.TRIM.get());
                String swordType = this.better_sword_trims$getSwordType(result);
                if (oldTrim != null && "minecraft:copper_ingot".equals(oldTrim.getIngredient()) && swordType != null) {
                    String configKey = swordType + "_copper";
                    SwordConfig cfg = ConfigManager.getConfig(configKey);
                    int baseMaxDurability = base.getMaxDamage();
                    int originalDurability = (int)((double)baseMaxDurability / cfg.durabilityMultiplier);
                    int baseDamage = base.getDamageValue();
                    float damageRatio = baseMaxDurability > 0 ? (float)baseDamage / (float)baseMaxDurability : 0.0f;
                    result.set(DataComponents.MAX_DAMAGE, (Object)originalDurability);
                    result.setDamageValue((int)((float)originalDurability * damageRatio));
                }
                ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(trimMaterial);
                result.set((DataComponentType)ModDataComponents.TRIM.get(), (Object)trimComponent);
                if (trimMaterial.equals("minecraft:copper_ingot") && (oldTrim == null || !"minecraft:copper_ingot".equals(oldTrim.getIngredient())) && swordType != null) {
                    String configKey = swordType + "_copper";
                    SwordConfig cfg = ConfigManager.getConfig(configKey);
                    int currentDurability = result.getMaxDamage();
                    int newMaxDurability = (int)((double)currentDurability * cfg.durabilityMultiplier);
                    int currentDamage = result.getDamageValue();
                    float damageRatio = currentDurability > 0 ? (float)currentDamage / (float)currentDurability : 0.0f;
                    result.set(DataComponents.MAX_DAMAGE, (Object)newMaxDurability);
                    result.setDamageValue((int)((float)newMaxDurability * damageRatio));
                }
                ModDataComponents.SwordTrimComponent swordTrimComponent = (ModDataComponents.SwordTrimComponent)result.get((DataComponentType)ModDataComponents.TRIM.get());
            } else {
                System.out.println("[DEBUG] Trim material is null, not processing");
            }
        } else {
            System.out.println("[DEBUG] Conditions not met for smithing_trim processing");
        }
    }

    @Unique
    private boolean better_sword_trims$isSword(ItemStack stack) {
        return stack.getItem() == Items.IRON_SWORD || stack.getItem() == Items.GOLDEN_SWORD || stack.getItem() == Items.DIAMOND_SWORD || stack.getItem() == Items.NETHERITE_SWORD;
    }

    @Unique
    private String better_sword_trims$getTrimMaterialFromItem(ItemStack item) {
        if (item.isEmpty()) {
            return null;
        }
        if (item.is(Items.COPPER_INGOT)) {
            return "minecraft:copper_ingot";
        }
        if (item.is(Items.EMERALD)) {
            return "minecraft:emerald";
        }
        if (item.is(Items.LAPIS_LAZULI)) {
            return "minecraft:lapis_lazuli";
        }
        if (item.is(Items.QUARTZ)) {
            return "minecraft:quartz";
        }
        if (item.is(Items.REDSTONE)) {
            return "minecraft:redstone";
        }
        if (item.is(Items.CRYING_OBSIDIAN)) {
            return "minecraft:crying_obsidian";
        }
        return null;
    }

    @Unique
    private String better_sword_trims$getSwordType(ItemStack stack) {
        if (stack.getItem() == Items.NETHERITE_SWORD) {
            return "netherite";
        }
        if (stack.getItem() == Items.DIAMOND_SWORD) {
            return "diamond";
        }
        if (stack.getItem() == Items.GOLDEN_SWORD) {
            return "golden";
        }
        if (stack.getItem() == Items.IRON_SWORD) {
            return "iron";
        }
        return null;
    }
}

