/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModRecipes;

public class SwordTrimTransformRecipe
implements SmithingRecipe {
    private final Ingredient template;
    private final Ingredient base;
    private final Ingredient addition;
    private final String ingredientId;

    public SwordTrimTransformRecipe(Ingredient template, Ingredient base, Ingredient addition, String ingredientId) {
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.ingredientId = ingredientId;
    }

    public boolean matches(SmithingRecipeInput input, Level level) {
        return this.template.test(input.template()) && this.base.test(input.base()) && this.addition.test(input.addition());
    }

    public ItemStack assemble(SmithingRecipeInput input, HolderLookup.Provider registries) {
        String swordType;
        ItemStack baseStack = input.base();
        ItemStack resultStack = baseStack.copy();
        int trueBaseDurability = this.getBaseDurability(resultStack);
        int currentMaxDurability = resultStack.getMaxDamage();
        int currentDamage = resultStack.getDamageValue();
        float damageRatio = currentMaxDurability > 0 ? (float)currentDamage / (float)currentMaxDurability : 0.0f;
        resultStack.set(DataComponents.MAX_DAMAGE, (Object)trueBaseDurability);
        resultStack.setDamageValue((int)((float)trueBaseDurability * damageRatio));
        ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(this.ingredientId);
        resultStack.set((DataComponentType)ModDataComponents.TRIM.get(), (Object)trimComponent);
        if ("minecraft:copper_ingot".equals(this.ingredientId) && (swordType = this.getSwordType(resultStack)) != null) {
            String configKey = swordType + "_copper";
            SwordConfig cfg = ConfigManager.getConfig(configKey);
            int newMaxDurability = (int)((double)trueBaseDurability * cfg.durabilityMultiplier);
            resultStack.set(DataComponents.MAX_DAMAGE, (Object)newMaxDurability);
            resultStack.setDamageValue((int)((float)newMaxDurability * damageRatio));
        }
        return resultStack;
    }

    private String getSwordType(ItemStack stack) {
        if (stack.getItem() == Items.NETHERITE_SWORD) {
            return "netherite";
        }
        if (stack.getItem() == Items.DIAMOND_SWORD) {
            return "diamond";
        }
        if (stack.getItem() == Items.GOLDEN_SWORD) {
            return "golden";
        }
        if (stack.getItem() == Items.IRON_SWORD) {
            return "iron";
        }
        return null;
    }

    private int getBaseDurability(ItemStack stack) {
        ItemStack freshStack = new ItemStack((ItemLike)stack.getItem());
        return freshStack.getMaxDamage();
    }

    public ItemStack getResultItem(HolderLookup.Provider registries) {
        ItemStack[] baseItems = this.base.getItems();
        if (baseItems.length > 0) {
            String swordType;
            ItemStack exampleResult = baseItems[0].copy();
            ModDataComponents.SwordTrimComponent trimComponent = new ModDataComponents.SwordTrimComponent(this.ingredientId);
            exampleResult.set((DataComponentType)ModDataComponents.TRIM.get(), (Object)trimComponent);
            if ("minecraft:copper_ingot".equals(this.ingredientId) && (swordType = this.getSwordType(exampleResult)) != null) {
                String configKey = swordType + "_copper";
                SwordConfig cfg = ConfigManager.getConfig(configKey);
                int baseDurability = exampleResult.getMaxDamage();
                int newMaxDurability = (int)((double)baseDurability * cfg.durabilityMultiplier);
                exampleResult.set(DataComponents.MAX_DAMAGE, (Object)newMaxDurability);
            }
            exampleResult.setDamageValue(0);
            return exampleResult;
        }
        return ItemStack.EMPTY;
    }

    public boolean isTemplateIngredient(ItemStack stack) {
        return this.template.test(stack);
    }

    public boolean isBaseIngredient(ItemStack stack) {
        return this.base.test(stack);
    }

    public boolean isAdditionIngredient(ItemStack stack) {
        return this.addition.test(stack);
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.SWORD_TRIM_TRANSFORM_RECIPE.get();
    }

    public RecipeType<?> getType() {
        return RecipeType.SMITHING;
    }

    public boolean isIncomplete() {
        return this.template.isEmpty() || this.base.isEmpty() || this.addition.isEmpty();
    }

    public static class Serializer
    implements RecipeSerializer<SwordTrimTransformRecipe> {
        private static final MapCodec<SwordTrimTransformRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.fieldOf("template").forGetter(recipe -> recipe.template), (App)Ingredient.CODEC.fieldOf("base").forGetter(recipe -> recipe.base), (App)Ingredient.CODEC.fieldOf("addition").forGetter(recipe -> recipe.addition), (App)Codec.STRING.fieldOf("ingredient_id").forGetter(recipe -> recipe.ingredientId)).apply((Applicative)instance, SwordTrimTransformRecipe::new));
        private static final StreamCodec<RegistryFriendlyByteBuf, SwordTrimTransformRecipe> STREAM_CODEC = StreamCodec.of(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<SwordTrimTransformRecipe> codec() {
            return CODEC;
        }

        public StreamCodec<RegistryFriendlyByteBuf, SwordTrimTransformRecipe> streamCodec() {
            return STREAM_CODEC;
        }

        private static SwordTrimTransformRecipe fromNetwork(RegistryFriendlyByteBuf buffer) {
            Ingredient template = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient base = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            Ingredient addition = (Ingredient)Ingredient.CONTENTS_STREAM_CODEC.decode((Object)buffer);
            String ingredientId = buffer.readUtf();
            return new SwordTrimTransformRecipe(template, base, addition, ingredientId);
        }

        private static void toNetwork(RegistryFriendlyByteBuf buffer, SwordTrimTransformRecipe recipe) {
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.template);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.base);
            Ingredient.CONTENTS_STREAM_CODEC.encode((Object)buffer, (Object)recipe.addition);
            buffer.writeUtf(recipe.ingredientId);
        }
    }
}

