/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.util;

import java.util.List;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.night.better_sword_trims.component.ModDataComponents;
import net.night.better_sword_trims.config.ConfigManager;
import net.night.better_sword_trims.config.SwordConfig;
import net.night.better_sword_trims.swords.ModItems;

public class TrimEffectHelper {
    public static ModItems.TrimMaterial getTrimMaterialFromIngredient(String ingredient) {
        return switch (ingredient) {
            case "minecraft:crying_obsidian" -> ModItems.TrimMaterial.WEEPING_OBSIDIAN;
            case "minecraft:lapis_lazuli" -> ModItems.TrimMaterial.LAPIS;
            case "minecraft:emerald" -> ModItems.TrimMaterial.EMERALD;
            case "minecraft:quartz" -> ModItems.TrimMaterial.QUARTZ;
            case "minecraft:redstone" -> ModItems.TrimMaterial.REDSTONE;
            case "minecraft:copper_ingot" -> ModItems.TrimMaterial.COPPER;
            default -> null;
        };
    }

    public static String getSwordTypeFromItem(ItemStack stack) {
        String itemId = stack.getItem().toString();
        if (itemId.contains("netherite_sword")) {
            return "netherite";
        }
        if (itemId.contains("diamond_sword")) {
            return "diamond";
        }
        if (itemId.contains("golden_sword")) {
            return "golden";
        }
        if (itemId.contains("iron_sword")) {
            return "iron";
        }
        return null;
    }

    public static void applyTrimEffect(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        Level level;
        ModDataComponents.SwordTrimComponent trimComponent = (ModDataComponents.SwordTrimComponent)stack.get((DataComponentType)ModDataComponents.TRIM.get());
        if (trimComponent == null) {
            return;
        }
        ModItems.TrimMaterial trimMaterial = TrimEffectHelper.getTrimMaterialFromIngredient(trimComponent.getIngredient());
        if (trimMaterial == null) {
            return;
        }
        String swordType = TrimEffectHelper.getSwordTypeFromItem(stack);
        if (swordType == null) {
            return;
        }
        String configKey = swordType + "_" + trimMaterial.getName();
        SwordConfig cfg = ConfigManager.getConfig(configKey);
        if (!target.level().isClientSide && (level = target.level()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            TrimEffectHelper.applyEffect(trimMaterial, cfg, stack, target, attacker, level2);
        }
    }

    private static void applyEffect(ModItems.TrimMaterial trimMaterial, SwordConfig cfg, ItemStack stack, LivingEntity target, LivingEntity attacker, ServerLevel level) {
        switch (trimMaterial) {
            case LAPIS: {
                int glowTicks = (int)(cfg.highlights.durationSeconds * 20.0);
                if (glowTicks > 0) {
                    target.addEffect(new MobEffectInstance(MobEffects.GLOWING, glowTicks, 0));
                }
                TrimEffectHelper.highlightSameTypeEntities(target, level, glowTicks);
                break;
            }
            case QUARTZ: {
                target.addTag("better_sword_trims:quartz_kill");
                int extraXp = cfg == null ? 0 : cfg.experience;
                target.addTag("better_sword_trims:extra_xp_" + extraXp);
                break;
            }
            case COPPER: {
                break;
            }
            case EMERALD: {
                int levAmp;
                int levTicks = (int)(cfg.levitation.durationSeconds * 20.0);
                int n = levAmp = cfg == null ? 0 : cfg.levitation.amplifier;
                if (levTicks <= 0) break;
                target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, levTicks, levAmp));
                break;
            }
            case REDSTONE: {
                int slowAmp;
                int slowTicks = (int)(cfg.slowness.durationSeconds * 20.0);
                int n = slowAmp = cfg == null ? 0 : cfg.slowness.amplifier;
                if (slowTicks <= 0) break;
                target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slowTicks, slowAmp));
                break;
            }
            case WEEPING_OBSIDIAN: {
                TrimEffectHelper.applyAreaDamage(stack, target, attacker, level, cfg);
            }
        }
    }

    private static void highlightSameTypeEntities(LivingEntity target, ServerLevel level, int glowTicks) {
        EntityType targetType = target.getType();
        AABB searchArea = target.getBoundingBox().inflate(32.0);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, searchArea, entity -> entity.getType() == targetType && entity != target);
        for (LivingEntity entity2 : nearbyEntities) {
            if (glowTicks <= 0) continue;
            entity2.addEffect(new MobEffectInstance(MobEffects.GLOWING, glowTicks, 0));
        }
    }

    private static void applyAreaDamage(ItemStack stack, LivingEntity target, LivingEntity attacker, ServerLevel level, SwordConfig cfg) {
        AABB damageArea = target.getBoundingBox().inflate(3.0);
        float baseDamage = (float)attacker.getAttributeValue(Attributes.ATTACK_DAMAGE);
        List nearbyEntities = level.getEntitiesOfClass(LivingEntity.class, damageArea, entity -> entity != target && entity != attacker && entity.isAlive());
        double configured = cfg == null ? 0.0 : cfg.areaDamage.amount;
        for (LivingEntity entity2 : nearbyEntities) {
            float damage;
            double distance = entity2.distanceTo((Entity)target);
            if (configured > 0.0) {
                damage = (float)configured;
            } else {
                float damageMultiplier = (float)(1.0 - distance / 3.0 * 0.5);
                damage = baseDamage * damageMultiplier * 0.5f;
            }
            entity2.hurt(level.damageSources().mobAttack(attacker), damage);
            level.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, entity2.getX(), entity2.getY() + (double)entity2.getBbHeight() * 0.5, entity2.getZ(), 2, 0.2, 0.2, 0.2, 0.0);
        }
    }
}

