/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.event;

import com.mojang.brigadier.CommandDispatcher;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingExperienceDropEvent;
import net.night.better_sword_trims.command.ReloadCommand;
import net.night.better_sword_trims.util.TrimEffectHelper;

@EventBusSubscriber(modid="better_sword_trims")
public class ModEvents {
    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        ReloadCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onLivingDamage(LivingDamageEvent.Pre event) {
        LivingEntity attacker;
        ItemStack weapon;
        Entity entity = event.getSource().getDirectEntity();
        if (entity instanceof LivingEntity && !(weapon = (attacker = (LivingEntity)entity).getMainHandItem()).isEmpty() && weapon.getItem().toString().contains("sword")) {
            TrimEffectHelper.applyTrimEffect(weapon, event.getEntity(), attacker);
        }
    }

    @SubscribeEvent
    public static void onLivingExperienceDrop(LivingExperienceDropEvent event) {
        int originalXp;
        LivingEntity entity = event.getEntity();
        int finalXp = originalXp = event.getDroppedExperience();
        Set tags = entity.getTags();
        if (tags.contains("better_sword_trims:quartz_kill")) {
            finalXp = originalXp * 2;
            entity.removeTag("better_sword_trims:quartz_kill");
        }
        String prefix = "better_sword_trims:extra_xp_";
        for (String tag : tags) {
            if (!tag.startsWith(prefix)) continue;
            String num = tag.substring(prefix.length());
            try {
                int add = Integer.parseInt(num);
                finalXp += add;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            entity.removeTag(tag);
        }
        event.setDroppedExperience(finalXp);
    }
}

