/*
 * Decompiled with CFR 0.152.
 */
package net.night.better_sword_trims.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class AddItemModifier
extends LootModifier {
    public static final MapCodec<AddItemModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> AddItemModifier.codecStart((RecordCodecBuilder.Instance)instance).and(instance.group((App)ItemStack.CODEC.fieldOf("item").forGetter(m -> m.item), (App)Codec.STRING.fieldOf("loot_table").forGetter(m -> m.targetLootTable))).apply((Applicative)instance, AddItemModifier::new));
    private final ItemStack item;
    private final String targetLootTable;

    public AddItemModifier(LootItemCondition[] conditionsIn, ItemStack item, String targetLootTable) {
        super(conditionsIn);
        this.item = item;
        this.targetLootTable = targetLootTable;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(@NotNull ObjectArrayList<ItemStack> generatedLoot, @NotNull LootContext context) {
        ResourceLocation lootTableId = context.getQueriedLootTableId();
        if (lootTableId.toString().contains(this.targetLootTable)) {
            generatedLoot.add((Object)this.item.copy());
        }
        return generatedLoot;
    }

    @NotNull
    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

